/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.weaving.jpa;

import java.io.IOException;
import java.io.Writer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipException;
import javax.persistence.spi.ClassTransformer;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.StaticWeaveException;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.StaticWeaveInfo;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.Archive;

public class StaticWeaveClassTransformer {
    private ArrayList<ClassTransformer> classTransformers;
    StaticWeaveInfo info;
    private ClassLoader aClassLoader;

    public StaticWeaveClassTransformer(URL inputArchiveURL, ClassLoader aclassloader) throws Exception {
        this(inputArchiveURL, null, aclassloader, null, 8);
    }

    public StaticWeaveClassTransformer(URL inputArchiveURL, String persistenceXMLLocation, ClassLoader aclassloader, Writer logWriter, int loglevel) throws URISyntaxException, IOException {
        this.aClassLoader = aclassloader;
        this.info = new StaticWeaveInfo(logWriter, loglevel);
        this.buildClassTransformers(inputArchiveURL, persistenceXMLLocation, aclassloader);
    }

    public byte[] transform(String originalClassName, Class originalClass, byte[] originalClassBytes) throws IllegalClassFormatException {
        byte[] newClassBytes = null;
        for (ClassTransformer transformer : this.classTransformers) {
            newClassBytes = transformer.transform(this.aClassLoader, originalClassName, originalClass, null, originalClassBytes);
            if (newClassBytes != null) break;
        }
        return newClassBytes;
    }

    private void buildClassTransformers(URL inputArchiveURL, String persistenceXMLLocation, ClassLoader aclassloader) throws URISyntaxException, IOException {
        if (this.classTransformers != null) {
            return;
        }
        this.classTransformers = new ArrayList();
        try (Archive archive = null;){
            try {
                archive = new ArchiveFactoryImpl().createArchive(inputArchiveURL, persistenceXMLLocation == null ? "META-INF/persistence.xml" : persistenceXMLLocation, null);
                List<SEPersistenceUnitInfo> persistenceUnitsList = PersistenceUnitProcessor.processPersistenceArchive(archive, aclassloader);
                if (persistenceUnitsList == null) {
                    throw PersistenceUnitLoadingException.couldNotGetUnitInfoFromUrl(inputArchiveURL);
                }
                HashMap emptyMap = new HashMap(0);
                for (SEPersistenceUnitInfo unitInfo : persistenceUnitsList) {
                    String puName = unitInfo.getPersistenceUnitName();
                    String sessionName = (String)unitInfo.getProperties().get("eclipselink.session-name");
                    if (sessionName == null) {
                        sessionName = puName;
                    }
                    EntityManagerSetupImpl emSetupImpl = new EntityManagerSetupImpl(puName, sessionName);
                    emSetupImpl.setStaticWeaveInfo(this.info);
                    ClassTransformer transformer = emSetupImpl.predeploy(unitInfo, emptyMap);
                    if (transformer == null) continue;
                    this.classTransformers.add(transformer);
                }
            }
            catch (ZipException e) {
                throw StaticWeaveException.exceptionOpeningArchive(inputArchiveURL, e);
            }
        }
    }
}

