/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiServiceRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Arguments used when enabling HDFS automatic failover.")
public class ApiHdfsFailoverArguments {
    @SerializedName(value="nameservice")
    private String nameservice = null;
    @SerializedName(value="zooKeeperService")
    private ApiServiceRef zooKeeperService = null;
    @SerializedName(value="activeFCName")
    private String activeFCName = null;
    @SerializedName(value="standByFCName")
    private String standByFCName = null;

    public ApiHdfsFailoverArguments nameservice(String nameservice) {
        this.nameservice = nameservice;
        return this;
    }

    @ApiModelProperty(value="Nameservice for which to enable automatic failover.")
    public String getNameservice() {
        return this.nameservice;
    }

    public void setNameservice(String nameservice) {
        this.nameservice = nameservice;
    }

    public ApiHdfsFailoverArguments zooKeeperService(ApiServiceRef zooKeeperService) {
        this.zooKeeperService = zooKeeperService;
        return this;
    }

    @ApiModelProperty(value="The ZooKeeper service to use.")
    public ApiServiceRef getZooKeeperService() {
        return this.zooKeeperService;
    }

    public void setZooKeeperService(ApiServiceRef zooKeeperService) {
        this.zooKeeperService = zooKeeperService;
    }

    public ApiHdfsFailoverArguments activeFCName(String activeFCName) {
        this.activeFCName = activeFCName;
        return this;
    }

    @ApiModelProperty(value="Name of the failover controller to create for the active NameNode.")
    public String getActiveFCName() {
        return this.activeFCName;
    }

    public void setActiveFCName(String activeFCName) {
        this.activeFCName = activeFCName;
    }

    public ApiHdfsFailoverArguments standByFCName(String standByFCName) {
        this.standByFCName = standByFCName;
        return this;
    }

    @ApiModelProperty(value="Name of the failover controller to create for the stand-by NameNode.")
    public String getStandByFCName() {
        return this.standByFCName;
    }

    public void setStandByFCName(String standByFCName) {
        this.standByFCName = standByFCName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHdfsFailoverArguments apiHdfsFailoverArguments = (ApiHdfsFailoverArguments)o;
        return Objects.equals(this.nameservice, apiHdfsFailoverArguments.nameservice) && Objects.equals(this.zooKeeperService, apiHdfsFailoverArguments.zooKeeperService) && Objects.equals(this.activeFCName, apiHdfsFailoverArguments.activeFCName) && Objects.equals(this.standByFCName, apiHdfsFailoverArguments.standByFCName);
    }

    public int hashCode() {
        return Objects.hash(this.nameservice, this.zooKeeperService, this.activeFCName, this.standByFCName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHdfsFailoverArguments {\n");
        sb.append("    nameservice: ").append(this.toIndentedString(this.nameservice)).append("\n");
        sb.append("    zooKeeperService: ").append(this.toIndentedString(this.zooKeeperService)).append("\n");
        sb.append("    activeFCName: ").append(this.toIndentedString(this.activeFCName)).append("\n");
        sb.append("    standByFCName: ").append(this.toIndentedString(this.standByFCName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

