/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.repository.convert;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.support.VaultResponse;

public class SecretDocument {
    @Nullable
    private String id;
    private final Map<String, Object> body;

    public SecretDocument() {
        this(null, new LinkedHashMap<String, Object>());
    }

    public SecretDocument(Map<String, Object> body) {
        this(null, body);
    }

    public SecretDocument(@Nullable String id, Map<String, Object> body) {
        Assert.notNull(body, (String)"Body must not be null");
        this.id = id;
        this.body = body;
    }

    public SecretDocument(String id) {
        this(id, new LinkedHashMap<String, Object>());
    }

    public static SecretDocument from(@Nullable String id, VaultResponse vaultResponse) {
        return new SecretDocument(id, (Map)vaultResponse.getData());
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    @Nullable
    public Object get(String key) {
        return this.body.get(key);
    }

    public void put(String key, Object value) {
        this.body.put(key, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretDocument)) {
            return false;
        }
        SecretDocument other = (SecretDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, Object> this$body = this.getBody();
        Map<String, Object> other$body = other.getBody();
        return !(this$body == null ? other$body != null : !((Object)this$body).equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecretDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, Object> $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        return result;
    }

    public String toString() {
        return "SecretDocument(id=" + this.getId() + ", body=" + this.getBody() + ")";
    }
}

