"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const virtual_1 = require("../tree/virtual");
function generateStringOfLength(l) {
    return new Array(l).fill(0).map(_x => {
        return 'abcdefghijklmnopqrstuvwxyz'[Math.floor(Math.random() * 26)];
    }).join('');
}
function random(from, to) {
    return Math.floor(Math.random() * (to - from)) + from;
}
function default_1(options) {
    return () => {
        const root = ('root' in options) ? options.root : '/';
        const map = new virtual_1.VirtualTree();
        const nbFiles = ('multiFiles' in options)
            ? (typeof options.multiFiles == 'number' ? options.multiFiles : random(2, 12))
            : 1;
        for (let i = 0; i < nbFiles; i++) {
            const path = 'a/b/c/d/e/f'.slice(Math.random() * 10);
            const fileName = generateStringOfLength(20);
            const content = generateStringOfLength(100);
            map.create(root + '/' + path + '/' + fileName, content);
        }
        return map;
    };
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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