/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/cdk/a11y"),require("@angular/cdk/overlay"),require("@angular/common"),require("@angular/core"),require("@angular/material/core"),require("@angular/cdk/portal"),require("@angular/cdk/keycodes"),require("rxjs/operators/startWith"),require("rxjs/operators/switchMap"),require("rxjs/operators/take"),require("rxjs/observable/merge"),require("rxjs/Subscription"),require("@angular/animations"),require("rxjs/Subject"),require("@angular/cdk/coercion"),require("@angular/cdk/bidi"),require("rxjs/operators/filter"),require("rxjs/observable/of")):"function"==typeof define&&define.amd?define(["exports","@angular/cdk/a11y","@angular/cdk/overlay","@angular/common","@angular/core","@angular/material/core","@angular/cdk/portal","@angular/cdk/keycodes","rxjs/operators/startWith","rxjs/operators/switchMap","rxjs/operators/take","rxjs/observable/merge","rxjs/Subscription","@angular/animations","rxjs/Subject","@angular/cdk/coercion","@angular/cdk/bidi","rxjs/operators/filter","rxjs/observable/of"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.menu=e.ng.material.menu||{}),e.ng.cdk.a11y,e.ng.cdk.overlay,e.ng.common,e.ng.core,e.ng.material.core,e.ng.cdk.portal,e.ng.cdk.keycodes,e.Rx.operators,e.Rx.operators,e.Rx.operators,e.Rx.Observable,e.Rx,e.ng.animations,e.Rx,e.ng.cdk.coercion,e.ng.cdk.bidi,e.Rx.operators,e.Rx.Observable)}(this,function(e,t,n,o,i,r,s,a,u,p,l,m,c,h,d,g,f,y,_){"use strict";function b(e,t){function n(){this.constructor=e}O(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}function v(){throw Error('mat-menu-trigger: must pass in an mat-menu instance.\n\n    Example:\n      <mat-menu #menu="matMenu"></mat-menu>\n      <button [matMenuTriggerFor]="menu"></button>')}function M(){throw Error('x-position value must be either \'before\' or after\'.\n      Example: <mat-menu x-position="before" #menu="matMenu"></mat-menu>')}function x(){throw Error('y-position value must be either \'above\' or below\'.\n      Example: <mat-menu y-position="above" #menu="matMenu"></mat-menu>')}function w(e){return function(){return e.scrollStrategies.reposition()}}var O=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])},k={transformMenu:h.trigger("transformMenu",[h.state("void",h.style({opacity:0,transform:"scale(0.01, 0.01)"})),h.state("enter-start",h.style({opacity:1,transform:"scale(1, 0.5)"})),h.state("enter",h.style({transform:"scale(1, 1)"})),h.transition("void => enter-start",h.animate("100ms linear")),h.transition("enter-start => enter",h.animate("300ms cubic-bezier(0.25, 0.8, 0.25, 1)")),h.transition("* => void",h.animate("150ms 50ms linear",h.style({opacity:0})))]),fadeInItems:h.trigger("fadeInItems",[h.state("showing",h.style({opacity:1})),h.transition("void => *",[h.style({opacity:0}),h.animate("400ms 100ms cubic-bezier(0.55, 0, 0.55, 0.2)")])])},P=k.fadeInItems,R=k.transformMenu,C=function(){function e(){}return e}(),E=r.mixinDisableRipple(r.mixinDisabled(C)),S=function(e){function n(t,n,o){var i=e.call(this)||this;return i._elementRef=t,i._focusMonitor=o,i._hovered=new d.Subject,i._highlighted=!1,i._triggersSubmenu=!1,o&&o.monitor(i._getHostElement(),!1),i._document=n,i}return b(n,e),n.prototype.focus=function(e){void 0===e&&(e="program"),this._focusMonitor?this._focusMonitor.focusVia(this._getHostElement(),e):this._getHostElement().focus()},n.prototype.ngOnDestroy=function(){this._focusMonitor&&this._focusMonitor.stopMonitoring(this._getHostElement()),this._hovered.complete()},n.prototype._getTabIndex=function(){return this.disabled?"-1":"0"},n.prototype._getHostElement=function(){return this._elementRef.nativeElement},n.prototype._checkDisabled=function(e){this.disabled&&(e.preventDefault(),e.stopPropagation())},n.prototype._emitHoverEvent=function(){this.disabled||this._hovered.next(this)},n.prototype.getLabel=function(){var e=this._elementRef.nativeElement,t=this._document?this._document.TEXT_NODE:3,n="";if(e.childNodes)for(var o=e.childNodes.length,i=0;i<o;i++)e.childNodes[i].nodeType===t&&(n+=e.childNodes[i].textContent);return n.trim()},n.decorators=[{type:i.Component,args:[{selector:"[mat-menu-item]",exportAs:"matMenuItem",inputs:["disabled","disableRipple"],host:{role:"menuitem",class:"mat-menu-item","[class.mat-menu-item-highlighted]":"_highlighted","[class.mat-menu-item-submenu-trigger]":"_triggersSubmenu","[attr.tabindex]":"_getTabIndex()","[attr.aria-disabled]":"disabled.toString()","[attr.disabled]":"disabled || null","(click)":"_checkDisabled($event)","(mouseenter)":"_emitHoverEvent()"},changeDetection:i.ChangeDetectionStrategy.OnPush,encapsulation:i.ViewEncapsulation.None,preserveWhitespaces:!1,template:'<ng-content></ng-content><div class="mat-menu-ripple" matRipple [matRippleDisabled]="disableRipple || disabled" [matRippleTrigger]="_getHostElement()"></div>'}]}],n.ctorParameters=function(){return[{type:i.ElementRef},{type:void 0,decorators:[{type:i.Inject,args:[o.DOCUMENT]}]},{type:t.FocusMonitor}]},n}(E),I=function(){function e(e,t,n,o,i,r){this._template=e,this._componentFactoryResolver=t,this._appRef=n,this._injector=o,this._viewContainerRef=i,this._document=r}return e.prototype.attach=function(e){void 0===e&&(e={}),this._portal?this._portal.isAttached&&this._portal.detach():this._portal=new s.TemplatePortal(this._template,this._viewContainerRef),this._outlet||(this._outlet=new s.DomPortalOutlet(this._document.createElement("div"),this._componentFactoryResolver,this._appRef,this._injector));var t=this._template.elementRef.nativeElement;t.parentNode.insertBefore(this._outlet.outletElement,t),this._portal.attach(this._outlet,e)},e.prototype.ngOnDestroy=function(){this._outlet&&this._outlet.dispose()},e.decorators=[{type:i.Directive,args:[{selector:"ng-template[matMenuContent]"}]}],e.ctorParameters=function(){return[{type:i.TemplateRef},{type:i.ComponentFactoryResolver},{type:i.ApplicationRef},{type:i.Injector},{type:i.ViewContainerRef},{type:void 0,decorators:[{type:i.Inject,args:[o.DOCUMENT]}]}]},e}(),T=new i.InjectionToken("mat-menu-default-options"),j=function(){function e(e,t,n){this._elementRef=e,this._ngZone=t,this._defaultOptions=n,this._xPosition=this._defaultOptions.xPosition,this._yPosition=this._defaultOptions.yPosition,this._tabSubscription=c.Subscription.EMPTY,this._classList={},this._panelAnimationState="void",this._overlapTrigger=this._defaultOptions.overlapTrigger,this.closed=new i.EventEmitter,this.close=this.closed}return Object.defineProperty(e.prototype,"xPosition",{get:function(){return this._xPosition},set:function(e){"before"!==e&&"after"!==e&&M(),this._xPosition=e,this.setPositionClasses()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"yPosition",{get:function(){return this._yPosition},set:function(e){"above"!==e&&"below"!==e&&x(),this._yPosition=e,this.setPositionClasses()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"overlapTrigger",{get:function(){return this._overlapTrigger},set:function(e){this._overlapTrigger=g.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"panelClass",{set:function(e){e&&e.length&&(this._classList=e.split(" ").reduce(function(e,t){return e[t]=!0,e},{}),this._elementRef.nativeElement.className="",this.setPositionClasses())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"classList",{get:function(){return this.panelClass},set:function(e){this.panelClass=e},enumerable:!0,configurable:!0}),e.prototype.ngAfterContentInit=function(){var e=this;this._keyManager=new t.FocusKeyManager(this.items).withWrap().withTypeAhead(),this._tabSubscription=this._keyManager.tabOut.subscribe(function(){return e.close.emit("keydown")})},e.prototype.ngOnDestroy=function(){this._tabSubscription.unsubscribe(),this.closed.complete()},e.prototype._hovered=function(){var e=this;return this.items?this.items.changes.pipe(u.startWith(this.items),p.switchMap(function(e){return m.merge.apply(void 0,e.map(function(e){return e._hovered}))})):this._ngZone.onStable.asObservable().pipe(l.take(1),p.switchMap(function(){return e._hovered()}))},e.prototype._handleKeydown=function(e){switch(e.keyCode){case a.ESCAPE:this.closed.emit("keydown"),e.stopPropagation();break;case a.LEFT_ARROW:this.parentMenu&&"ltr"===this.direction&&this.closed.emit("keydown");break;case a.RIGHT_ARROW:this.parentMenu&&"rtl"===this.direction&&this.closed.emit("keydown");break;default:this._keyManager.onKeydown(e)}},e.prototype.focusFirstItem=function(e){var t=this;void 0===e&&(e="program"),this.lazyContent?this._ngZone.onStable.asObservable().pipe(l.take(1)).subscribe(function(){return t._keyManager.setFocusOrigin(e).setFirstItemActive()}):this._keyManager.setFocusOrigin(e).setFirstItemActive()},e.prototype.resetActiveItem=function(){this._keyManager.setActiveItem(-1)},e.prototype.setPositionClasses=function(e,t){void 0===e&&(e=this.xPosition),void 0===t&&(t=this.yPosition),this._classList["mat-menu-before"]="before"===e,this._classList["mat-menu-after"]="after"===e,this._classList["mat-menu-above"]="above"===t,this._classList["mat-menu-below"]="below"===t},e.prototype.setElevation=function(e){var t="mat-elevation-z"+(2+e),n=Object.keys(this._classList).find(function(e){return e.startsWith("mat-elevation-z")});n&&n!==this._previousElevation||(this._previousElevation&&(this._classList[this._previousElevation]=!1),this._classList[t]=!0,this._previousElevation=t)},e.prototype._startAnimation=function(){this._panelAnimationState="enter-start"},e.prototype._resetAnimation=function(){this._panelAnimationState="void"},e.prototype._onAnimationDone=function(e){"enter-start"===e.toState&&(this._panelAnimationState="enter")},e.decorators=[{type:i.Component,args:[{selector:"mat-menu",template:'<ng-template><div class="mat-menu-panel" [ngClass]="_classList" (keydown)="_handleKeydown($event)" (click)="closed.emit(\'click\')" [@transformMenu]="_panelAnimationState" (@transformMenu.done)="_onAnimationDone($event)" tabindex="-1" role="menu"><div class="mat-menu-content" [@fadeInItems]="\'showing\'"><ng-content></ng-content></div></div></ng-template>',styles:[".mat-menu-panel{min-width:112px;max-width:280px;overflow:auto;-webkit-overflow-scrolling:touch;max-height:calc(100vh - 48px);border-radius:2px;outline:0}.mat-menu-panel:not([class*=mat-elevation-z]){box-shadow:0 3px 1px -2px rgba(0,0,0,.2),0 2px 2px 0 rgba(0,0,0,.14),0 1px 5px 0 rgba(0,0,0,.12)}.mat-menu-panel.mat-menu-after.mat-menu-below{transform-origin:left top}.mat-menu-panel.mat-menu-after.mat-menu-above{transform-origin:left bottom}.mat-menu-panel.mat-menu-before.mat-menu-below{transform-origin:right top}.mat-menu-panel.mat-menu-before.mat-menu-above{transform-origin:right bottom}[dir=rtl] .mat-menu-panel.mat-menu-after.mat-menu-below{transform-origin:right top}[dir=rtl] .mat-menu-panel.mat-menu-after.mat-menu-above{transform-origin:right bottom}[dir=rtl] .mat-menu-panel.mat-menu-before.mat-menu-below{transform-origin:left top}[dir=rtl] .mat-menu-panel.mat-menu-before.mat-menu-above{transform-origin:left bottom}.mat-menu-panel.ng-animating{pointer-events:none}@media screen and (-ms-high-contrast:active){.mat-menu-panel{outline:solid 1px}}.mat-menu-content{padding-top:8px;padding-bottom:8px}.mat-menu-item{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;cursor:pointer;outline:0;border:none;-webkit-tap-highlight-color:transparent;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;display:block;line-height:48px;height:48px;padding:0 16px;text-align:left;text-decoration:none;position:relative}.mat-menu-item[disabled]{cursor:default}[dir=rtl] .mat-menu-item{text-align:right}.mat-menu-item .mat-icon{margin-right:16px;vertical-align:middle}[dir=rtl] .mat-menu-item .mat-icon{margin-left:16px;margin-right:0}.mat-menu-item-submenu-trigger{padding-right:32px}.mat-menu-item-submenu-trigger::after{width:0;height:0;border-style:solid;border-width:5px 0 5px 5px;border-color:transparent transparent transparent currentColor;content:'';display:inline-block;position:absolute;top:50%;right:16px;transform:translateY(-50%)}[dir=rtl] .mat-menu-item-submenu-trigger{padding-right:16px;padding-left:32px}[dir=rtl] .mat-menu-item-submenu-trigger::after{right:auto;left:16px;transform:rotateY(180deg) translateY(-50%)}button.mat-menu-item{width:100%}.mat-menu-ripple{top:0;left:0;right:0;bottom:0;position:absolute;pointer-events:none}"],changeDetection:i.ChangeDetectionStrategy.OnPush,encapsulation:i.ViewEncapsulation.None,preserveWhitespaces:!1,animations:[k.transformMenu,k.fadeInItems],exportAs:"matMenu"}]}],e.ctorParameters=function(){return[{type:i.ElementRef},{type:i.NgZone},{type:void 0,decorators:[{type:i.Inject,args:[T]}]}]},e.propDecorators={xPosition:[{type:i.Input}],yPosition:[{type:i.Input}],templateRef:[{type:i.ViewChild,args:[i.TemplateRef]}],items:[{type:i.ContentChildren,args:[S]}],lazyContent:[{type:i.ContentChild,args:[I]}],overlapTrigger:[{type:i.Input}],panelClass:[{type:i.Input,args:["class"]}],classList:[{type:i.Input}],closed:[{type:i.Output}],close:[{type:i.Output}]},e}(),A=new i.InjectionToken("mat-menu-scroll-strategy"),D={provide:A,deps:[n.Overlay],useFactory:w},F=function(){function e(e,t,n,o,r,s,a,u){this._overlay=e,this._element=t,this._viewContainerRef=n,this._scrollStrategy=o,this._parentMenu=r,this._menuItemInstance=s,this._dir=a,this._focusMonitor=u,this._overlayRef=null,this._menuOpen=!1,this._closeSubscription=c.Subscription.EMPTY,this._hoverSubscription=c.Subscription.EMPTY,this._openedByMouse=!1,this.menuOpened=new i.EventEmitter,this.onMenuOpen=this.menuOpened,this.menuClosed=new i.EventEmitter,this.onMenuClose=this.menuClosed,s&&(s._triggersSubmenu=this.triggersSubmenu())}return Object.defineProperty(e.prototype,"_deprecatedMatMenuTriggerFor",{get:function(){return this.menu},set:function(e){this.menu=e},enumerable:!0,configurable:!0}),e.prototype.ngAfterContentInit=function(){var e=this;this._checkMenu(),this.menu.close.subscribe(function(t){e._destroyMenu(),"click"===t&&e._parentMenu&&e._parentMenu.closed.emit(t)}),this.triggersSubmenu()&&(this._hoverSubscription=this._parentMenu._hovered().pipe(y.filter(function(t){return t===e._menuItemInstance})).subscribe(function(){e._openedByMouse=!0,e.openMenu()}))},e.prototype.ngOnDestroy=function(){this._overlayRef&&(this._overlayRef.dispose(),this._overlayRef=null),this._cleanUpSubscriptions()},Object.defineProperty(e.prototype,"menuOpen",{get:function(){return this._menuOpen},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"dir",{get:function(){return this._dir&&"rtl"===this._dir.value?"rtl":"ltr"},enumerable:!0,configurable:!0}),e.prototype.triggersSubmenu=function(){return!(!this._menuItemInstance||!this._parentMenu)},e.prototype.toggleMenu=function(){return this._menuOpen?this.closeMenu():this.openMenu()},e.prototype.openMenu=function(){var e=this;this._menuOpen||(this._createOverlay().attach(this._portal),this.menu.lazyContent&&this.menu.lazyContent.attach(this.menuData),this._closeSubscription=this._menuClosingActions().subscribe(function(){return e.closeMenu()}),this._initMenu(),this.menu instanceof j&&this.menu._startAnimation())},e.prototype.closeMenu=function(){this.menu.close.emit()},e.prototype.focus=function(e){void 0===e&&(e="program"),this._focusMonitor?this._focusMonitor.focusVia(this._element.nativeElement,e):this._element.nativeElement.focus()},e.prototype._destroyMenu=function(){this._overlayRef&&this.menuOpen&&(this._resetMenu(),this._closeSubscription.unsubscribe(),this._overlayRef.detach(),this.menu instanceof j&&this.menu._resetAnimation())},e.prototype._initMenu=function(){this.menu.parentMenu=this.triggersSubmenu()?this._parentMenu:void 0,this.menu.direction=this.dir,this._setMenuElevation(),this._setIsMenuOpen(!0),this.menu.focusFirstItem(this._openedByMouse?"mouse":"program")},e.prototype._setMenuElevation=function(){if(this.menu.setElevation){for(var e=0,t=this.menu.parentMenu;t;)e++,t=t.parentMenu;this.menu.setElevation(e)}},e.prototype._resetMenu=function(){this._setIsMenuOpen(!1),this._openedByMouse?this.triggersSubmenu()||this.focus("mouse"):this.focus(),this._openedByMouse=!1},e.prototype._setIsMenuOpen=function(e){this._menuOpen=e,this._menuOpen?this.menuOpened.emit():this.menuClosed.emit(),this.triggersSubmenu()&&(this._menuItemInstance._highlighted=e)},e.prototype._checkMenu=function(){this.menu||v()},e.prototype._createOverlay=function(){if(!this._overlayRef){this._portal=new s.TemplatePortal(this.menu.templateRef,this._viewContainerRef);var e=this._getOverlayConfig();this._subscribeToPositions(e.positionStrategy),this._overlayRef=this._overlay.create(e)}return this._overlayRef},e.prototype._getOverlayConfig=function(){return new n.OverlayConfig({positionStrategy:this._getPosition(),hasBackdrop:!this.triggersSubmenu(),backdropClass:"cdk-overlay-transparent-backdrop",direction:this.dir,scrollStrategy:this._scrollStrategy()})},e.prototype._subscribeToPositions=function(e){var t=this;e.onPositionChange.subscribe(function(e){var n="start"===e.connectionPair.overlayX?"after":"before",o="top"===e.connectionPair.overlayY?"below":"above";t.menu.setPositionClasses(n,o)})},e.prototype._getPosition=function(){var e="before"===this.menu.xPosition?["end","start"]:["start","end"],t=e[0],n=e[1],o="above"===this.menu.yPosition?["bottom","top"]:["top","bottom"],i=o[0],r=o[1],s=[i,r],a=s[0],u=s[1],p=[t,n],l=p[0],m=p[1],c=0;return this.triggersSubmenu()?(m=t="before"===this.menu.xPosition?"start":"end",n=l="end"===t?"start":"end",c="bottom"===i?8:-8):this.menu.overlapTrigger||(a="top"===i?"bottom":"top",u="top"===r?"bottom":"top"),this._overlay.position().connectedTo(this._element,{originX:t,originY:a},{overlayX:l,overlayY:i}).withDirection(this.dir).withOffsetY(c).withFallbackPosition({originX:n,originY:a},{overlayX:m,overlayY:i}).withFallbackPosition({originX:t,originY:u},{overlayX:l,overlayY:r},void 0,-c).withFallbackPosition({originX:n,originY:u},{overlayX:m,overlayY:r},void 0,-c)},e.prototype._cleanUpSubscriptions=function(){this._closeSubscription.unsubscribe(),this._hoverSubscription.unsubscribe()},e.prototype._menuClosingActions=function(){var e=this,t=this._overlayRef.backdropClick(),n=this._overlayRef.detachments(),o=this._parentMenu?this._parentMenu.close:_.of(),i=this._parentMenu?this._parentMenu._hovered().pipe(y.filter(function(t){return t!==e._menuItemInstance}),y.filter(function(){return e._menuOpen})):_.of();return m.merge(t,o,i,n)},e.prototype._handleMousedown=function(e){t.isFakeMousedownFromScreenReader(e)||(this._openedByMouse=!0,this.triggersSubmenu()&&e.preventDefault())},e.prototype._handleKeydown=function(e){var t=e.keyCode;this.triggersSubmenu()&&(t===a.RIGHT_ARROW&&"ltr"===this.dir||t===a.LEFT_ARROW&&"rtl"===this.dir)&&this.openMenu()},e.prototype._handleClick=function(e){this.triggersSubmenu()?(e.stopPropagation(),this.openMenu()):this.toggleMenu()},e.decorators=[{type:i.Directive,args:[{selector:"[mat-menu-trigger-for], [matMenuTriggerFor]",host:{"aria-haspopup":"true","(mousedown)":"_handleMousedown($event)","(keydown)":"_handleKeydown($event)","(click)":"_handleClick($event)"},exportAs:"matMenuTrigger"}]}],e.ctorParameters=function(){return[{type:n.Overlay},{type:i.ElementRef},{type:i.ViewContainerRef},{type:void 0,decorators:[{type:i.Inject,args:[A]}]},{type:j,decorators:[{type:i.Optional}]},{type:S,decorators:[{type:i.Optional},{type:i.Self}]},{type:f.Directionality,decorators:[{type:i.Optional}]},{type:t.FocusMonitor}]},e.propDecorators={_deprecatedMatMenuTriggerFor:[{type:i.Input,args:["mat-menu-trigger-for"]}],menu:[{type:i.Input,args:["matMenuTriggerFor"]}],menuData:[{type:i.Input,args:["matMenuTriggerData"]}],menuOpened:[{type:i.Output}],onMenuOpen:[{type:i.Output}],menuClosed:[{type:i.Output}],onMenuClose:[{type:i.Output}]},e}(),q={overlapTrigger:!0,xPosition:"after",yPosition:"below"},L=function(){function e(){}return e.decorators=[{type:i.NgModule,args:[{imports:[t.A11yModule,o.CommonModule,r.MatCommonModule,r.MatRippleModule,n.OverlayModule,s.PortalModule],exports:[j,S,F,I,r.MatCommonModule],declarations:[j,S,F,I],providers:[D,{provide:T,useValue:q}]}]}],e.ctorParameters=function(){return[]},e}();e.MAT_MENU_SCROLL_STRATEGY=A,e.MatMenuModule=L,e.MatMenu=j,e.MAT_MENU_DEFAULT_OPTIONS=T,e.MatMenuItem=S,e.MatMenuTrigger=F,e.matMenuAnimations=k,e.fadeInItems=P,e.transformMenu=R,e.MatMenuContent=I,e.ɵa20=C,e.ɵb20=E,e.ɵd20=D,e.ɵc20=w,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-menu.umd.min.js.map
