/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.exception;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;

public class HttpAction
extends TechnicalException {
    private static final long serialVersionUID = -3959659239684160075L;
    protected int code;

    protected HttpAction(int code) {
        super("Performing a " + code + " HTTP action");
        this.code = code;
    }

    public static HttpAction status(int status, WebContext context) {
        context.setResponseStatus(status);
        return new HttpAction(status);
    }

    public static HttpAction redirect(WebContext context, String url) {
        context.setResponseHeader("Location", url);
        context.setResponseStatus(302);
        return new HttpAction(302);
    }

    public static HttpAction ok(WebContext context, String content) {
        context.setResponseStatus(200);
        context.writeResponseContent(content);
        return new HttpAction(200);
    }

    public static HttpAction noContent(WebContext context) {
        context.setResponseStatus(204);
        context.writeResponseContent("");
        return new HttpAction(204);
    }

    public static HttpAction unauthorized(WebContext context) {
        context.setResponseStatus(401);
        return new HttpAction(401);
    }

    public static HttpAction forbidden(WebContext context) {
        context.setResponseStatus(403);
        return new HttpAction(403);
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String toString() {
        return CommonHelper.toNiceString(HttpAction.class, "code", this.code);
    }
}

