/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.VBucketAware;
import net.spy.memcached.protocol.binary.OperationImpl;
import net.spy.memcached.util.StringUtils;

abstract class MultiKeyOperationImpl
extends OperationImpl
implements VBucketAware,
KeyedOperation {
    protected final Map<String, Short> vbmap = Collections.synchronizedMap(new HashMap());

    protected MultiKeyOperationImpl(byte c, int o, OperationCallback cb) {
        super(c, o, cb);
    }

    @Override
    public Collection<String> getKeys() {
        return this.vbmap.keySet();
    }

    @Override
    public Collection<MemcachedNode> getNotMyVbucketNodes() {
        return this.notMyVbucketNodes;
    }

    @Override
    public void addNotMyVbucketNode(MemcachedNode node) {
        this.notMyVbucketNodes.add(node);
    }

    @Override
    public void setNotMyVbucketNodes(Collection<MemcachedNode> nodes) {
        this.notMyVbucketNodes = nodes;
    }

    @Override
    public void setVBucket(String k, short vb) {
        assert (this.vbmap.containsKey(k)) : "Key " + k + " not contained in operation";
        this.vbmap.put(k, vb);
    }

    @Override
    public short getVBucket(String k) {
        assert (this.vbmap.containsKey(k)) : "Key " + k + " not contained in operation";
        return this.vbmap.get(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Map<String, Short> map = this.vbmap;
        synchronized (map) {
            return super.toString() + " Keys: " + StringUtils.join(this.getKeys(), " ");
        }
    }
}

