/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.admin;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.admin.beans.BeanConverter;
import org.apache.knox.gateway.service.admin.beans.Topology;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.topology.TopologyService;

@Api(value="topology", description="The Knox Admin API to interact with topologies.")
@Path(value="/api/v1")
public class TopologiesResource {
    private static final String XML_EXT = ".xml";
    private static final String JSON_EXT = ".json";
    private static final String YAML_EXT = ".yml";
    private static final String TOPOLOGIES_API_PATH = "topologies";
    private static final String SINGLE_TOPOLOGY_API_PATH = "topologies/{id}";
    private static final String PROVIDERCONFIG_API_PATH = "providerconfig";
    private static final String SINGLE_PROVIDERCONFIG_API_PATH = "providerconfig/{name}";
    private static final String DESCRIPTORS_API_PATH = "descriptors";
    private static final String SINGLE_DESCRIPTOR_API_PATH = "descriptors/{name}";
    private static final int RESOURCE_NAME_LENGTH_MAX = 100;
    private static final Pattern RESOURCE_NAME_PATTERN = Pattern.compile("^[\\w-/.]+$");
    private static GatewaySpiMessages log = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    private static final Map<MediaType, String> mediaTypeFileExtensions = new HashMap<MediaType, String>();
    @Context
    private HttpServletRequest request;

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="topologies/{id}")
    public Topology getTopology(@PathParam(value="id") String id) {
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        if (services != null) {
            TopologyService ts = (TopologyService)services.getService(ServiceType.TOPOLOGY_SERVICE);
            GatewayConfig config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config");
            for (org.apache.knox.gateway.topology.Topology t : ts.getTopologies()) {
                if (!t.getName().equals(id)) continue;
                Topology convertedTopology = BeanConverter.getTopology(t);
                try {
                    convertedTopology.setUri(new URI(this.buildURI(t, config, this.request)));
                }
                catch (URISyntaxException se) {
                    convertedTopology.setUri(null);
                }
                List ambariManagedTopos = config.getReadOnlyOverrideTopologyNames();
                if (ambariManagedTopos.contains(convertedTopology.getName())) {
                    convertedTopology.setGenerated(true);
                }
                return convertedTopology;
            }
        }
        return null;
    }

    @ApiOperation(value="Get ALL topologies", notes="Get ALL topologies that are available within this Knox Gateway", response=SimpleTopologyWrapper.class)
    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="topologies")
    public SimpleTopologyWrapper getTopologies() {
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        GatewayConfig config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config");
        TopologyService ts = (TopologyService)services.getService(ServiceType.TOPOLOGY_SERVICE);
        ArrayList<SimpleTopology> st = new ArrayList<SimpleTopology>();
        for (org.apache.knox.gateway.topology.Topology t : ts.getTopologies()) {
            st.add(this.getSimpleTopology(t, config));
        }
        st.sort(new TopologyComparator());
        SimpleTopologyWrapper stw = new SimpleTopologyWrapper();
        stw.topologies.addAll(st);
        return stw;
    }

    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="topologies/{id}")
    public Topology uploadTopology(@PathParam(value="id") String id, Topology t) {
        Topology result = null;
        try {
            id = URLDecoder.decode(id, StandardCharsets.UTF_8.name());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TopologiesResource.isValidResourceName(id)) {
            log.invalidResourceName(id);
            throw new BadRequestException("Invalid topology name: " + id);
        }
        GatewayServices gs = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        t.setName(id);
        TopologyService ts = (TopologyService)gs.getService(ServiceType.TOPOLOGY_SERVICE);
        boolean existingGenerated = false;
        for (org.apache.knox.gateway.topology.Topology existingTopology : ts.getTopologies()) {
            if (!existingTopology.getName().equals(id)) continue;
            existingGenerated = existingTopology.isGenerated();
            break;
        }
        if (!existingGenerated) {
            ts.deployTopology(BeanConverter.getTopology(t));
            result = this.getTopology(id);
        } else {
            log.disallowedOverwritingGeneratedTopology(id);
        }
        return result;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="topologies/{id}")
    public Response deleteTopology(@PathParam(value="id") String id) {
        boolean deleted = false;
        if (!"admin".equals(id)) {
            GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
            TopologyService ts = (TopologyService)services.getService(ServiceType.TOPOLOGY_SERVICE);
            for (org.apache.knox.gateway.topology.Topology t : ts.getTopologies()) {
                if (!t.getName().equals(id)) continue;
                ts.deleteTopology(t);
                deleted = true;
            }
        } else {
            deleted = false;
        }
        return Response.ok().entity((Object)("{ \"deleted\" : " + deleted + " }")).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="providerconfig")
    public HrefListing getProviderConfigurations() {
        HrefListing listing = new HrefListing();
        listing.setHref(this.buildHref(this.request));
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        ArrayList<HrefListItem> configs = new ArrayList<HrefListItem>();
        TopologyService ts = (TopologyService)services.getService(ServiceType.TOPOLOGY_SERVICE);
        for (File providerConfig : ts.getProviderConfigurations()) {
            String id = FilenameUtils.getBaseName((String)providerConfig.getName());
            configs.add(new HrefListItem(this.buildHref(id, this.request), providerConfig.getName()));
        }
        listing.setItems(configs);
        return listing;
    }

    @GET
    @Produces(value={"application/xml", "application/json", "text/plain"})
    @Path(value="providerconfig/{name}")
    public Response getProviderConfiguration(@PathParam(value="name") String name) {
        Response response;
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        TopologyService ts = (TopologyService)services.getService(ServiceType.TOPOLOGY_SERVICE);
        File providerConfigFile = null;
        for (File pc : ts.getProviderConfigurations()) {
            if (!FilenameUtils.getBaseName((String)pc.getName()).equals(name)) continue;
            providerConfigFile = pc;
            break;
        }
        if (providerConfigFile != null) {
            try {
                byte[] content = FileUtils.readFileToByteArray(providerConfigFile);
                response = Response.ok().entity((Object)content).build();
            }
            catch (IOException e) {
                log.failedToReadConfigurationFile(providerConfigFile.getAbsolutePath(), (Exception)e);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        } else {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return response;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="providerconfig/{name}")
    public Response deleteProviderConfiguration(@PathParam(value="name") String name, @QueryParam(value="force") String force) {
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        TopologyService ts = (TopologyService)services.getService(ServiceType.TOPOLOGY_SERVICE);
        Response response = ts.deleteProviderConfiguration(name, Boolean.valueOf(force).booleanValue()) ? Response.ok().entity((Object)("{ \"deleted\" : \"provider config " + name + "\" }")).build() : Response.notModified().build();
        return response;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="descriptors/{name}")
    public Response deleteSimpleDescriptor(@PathParam(value="name") String name) {
        GatewayServices services;
        TopologyService ts;
        Response response = null;
        if (!"admin".equals(name) && (ts = (TopologyService)(services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services")).getService(ServiceType.TOPOLOGY_SERVICE)).deleteDescriptor(name)) {
            response = Response.ok().entity((Object)("{ \"deleted\" : \"descriptor " + name + "\" }")).build();
        }
        if (response == null) {
            response = Response.notModified().build();
        }
        return response;
    }

    @PUT
    @Consumes(value={"application/xml", "application/json", "text/plain"})
    @Path(value="providerconfig/{name}")
    public Response uploadProviderConfiguration(@PathParam(value="name") String name, @Context HttpHeaders headers, String content) {
        String filename;
        Response response = null;
        try {
            name = URLDecoder.decode(name, StandardCharsets.UTF_8.name());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TopologiesResource.isValidResourceName(name)) {
            log.invalidResourceName(name);
            throw new BadRequestException("Invalid provider configuration name: " + name);
        }
        GatewayServices gs = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        TopologyService ts = (TopologyService)gs.getService(ServiceType.TOPOLOGY_SERVICE);
        File existing = this.getExistingConfigFile(ts.getProviderConfigurations(), name);
        boolean isUpdate = existing != null;
        String string = filename = isUpdate ? existing.getName() : this.getFileNameForResource(name, headers);
        if (ts.deployProviderConfiguration(filename, content)) {
            try {
                response = isUpdate ? Response.noContent().build() : Response.created((URI)new URI(this.buildHref(this.request))).build();
            }
            catch (URISyntaxException e) {
                log.invalidResourceURI(e.getInput(), e.getReason(), (Exception)e);
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{ \"error\" : \"Failed to deploy provider configuration " + name + "\" }")).build();
            }
        }
        return response;
    }

    @PUT
    @Consumes(value={"application/json", "text/plain"})
    @Path(value="descriptors/{name}")
    public Response uploadSimpleDescriptor(@PathParam(value="name") String name, @Context HttpHeaders headers, String content) {
        String filename;
        Response response = null;
        try {
            name = URLDecoder.decode(name, StandardCharsets.UTF_8.name());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TopologiesResource.isValidResourceName(name)) {
            log.invalidResourceName(name);
            throw new BadRequestException("Invalid descriptor name: " + name);
        }
        GatewayServices gs = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        TopologyService ts = (TopologyService)gs.getService(ServiceType.TOPOLOGY_SERVICE);
        File existing = this.getExistingConfigFile(ts.getDescriptors(), name);
        boolean isUpdate = existing != null;
        String string = filename = isUpdate ? existing.getName() : this.getFileNameForResource(name, headers);
        if (ts.deployDescriptor(filename, content)) {
            try {
                response = isUpdate ? Response.noContent().build() : Response.created((URI)new URI(this.buildHref(this.request))).build();
            }
            catch (URISyntaxException e) {
                log.invalidResourceURI(e.getInput(), e.getReason(), (Exception)e);
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{ \"error\" : \"Failed to deploy descriptor " + name + "\" }")).build();
            }
        }
        return response;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="descriptors")
    public HrefListing getSimpleDescriptors() {
        HrefListing listing = new HrefListing();
        listing.setHref(this.buildHref(this.request));
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        ArrayList<HrefListItem> descriptors = new ArrayList<HrefListItem>();
        TopologyService ts = (TopologyService)services.getService(ServiceType.TOPOLOGY_SERVICE);
        for (File descriptor : ts.getDescriptors()) {
            String id = FilenameUtils.getBaseName((String)descriptor.getName());
            descriptors.add(new HrefListItem(this.buildHref(id, this.request), descriptor.getName()));
        }
        listing.setItems(descriptors);
        return listing;
    }

    @GET
    @Produces(value={"application/json", "text/plain"})
    @Path(value="descriptors/{name}")
    public Response getSimpleDescriptor(@PathParam(value="name") String name) {
        Response response;
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        TopologyService ts = (TopologyService)services.getService(ServiceType.TOPOLOGY_SERVICE);
        File descriptorFile = null;
        for (File sd : ts.getDescriptors()) {
            if (!FilenameUtils.getBaseName((String)sd.getName()).equals(name)) continue;
            descriptorFile = sd;
            break;
        }
        if (descriptorFile != null) {
            String mediaType = "application/json";
            try {
                if ("yml".equals(FilenameUtils.getExtension((String)descriptorFile.getName()))) {
                    mediaType = "text/plain";
                }
                byte[] content = FileUtils.readFileToByteArray((File)descriptorFile);
                response = Response.ok().type(mediaType).entity((Object)content).build();
            }
            catch (IOException e) {
                log.failedToReadConfigurationFile(descriptorFile.getAbsolutePath(), (Exception)e);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        } else {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return response;
    }

    private String getFileNameForResource(String resourceName, HttpHeaders headers) {
        String extension = FilenameUtils.getExtension((String)resourceName);
        String filename = extension != null && !extension.isEmpty() ? resourceName : ((extension = this.getExtensionForMediaType(headers.getMediaType())) != null ? resourceName + extension : resourceName + JSON_EXT);
        return filename;
    }

    private String getExtensionForMediaType(MediaType type) {
        String extension = null;
        for (Map.Entry<MediaType, String> entry : mediaTypeFileExtensions.entrySet()) {
            if (!type.isCompatible(entry.getKey())) continue;
            extension = entry.getValue();
            break;
        }
        return extension;
    }

    private File getExistingConfigFile(Collection<File> existing, String candidateName) {
        File result = null;
        for (File exists : existing) {
            if (!FilenameUtils.getBaseName((String)exists.getName()).equals(candidateName)) continue;
            result = exists;
            break;
        }
        return result;
    }

    private static boolean isValidResourceName(String name) {
        return name != null && name.length() <= 100 && RESOURCE_NAME_PATTERN.matcher(name).matches();
    }

    String buildURI(org.apache.knox.gateway.topology.Topology topology, GatewayConfig config, HttpServletRequest req) {
        String uri = this.buildXForwardBaseURL(req);
        uri = uri.replace(req.getContextPath(), "");
        String gatewayPath = config.getGatewayPath() != null ? config.getGatewayPath() : "gateway";
        return uri + "/" + gatewayPath + "/" + topology.getName();
    }

    String buildHref(HttpServletRequest req) {
        return this.buildHref((String)null, req);
    }

    String buildHref(String id, HttpServletRequest req) {
        StringBuilder href = new StringBuilder(this.buildXForwardBaseURL(req));
        String pathInfo = req.getPathInfo();
        while (pathInfo.endsWith("/")) {
            pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
        }
        href.append(pathInfo);
        if (id != null) {
            href.append('/').append(id);
        }
        return href.toString();
    }

    String buildHref(org.apache.knox.gateway.topology.Topology t, HttpServletRequest req) {
        return this.buildHref(t.getName(), req);
    }

    private SimpleTopology getSimpleTopology(org.apache.knox.gateway.topology.Topology t, GatewayConfig config) {
        String uri = this.buildURI(t, config, this.request);
        String href = this.buildHref(t, this.request);
        return new SimpleTopology(t, uri, href);
    }

    private String buildXForwardBaseURL(HttpServletRequest req) {
        String X_Forwarded = "X-Forwarded-";
        String X_Forwarded_Context = "X-Forwarded-Context";
        String X_Forwarded_Proto = "X-Forwarded-Proto";
        String X_Forwarded_Host = "X-Forwarded-Host";
        String X_Forwarded_Port = "X-Forwarded-Port";
        String X_Forwarded_Server = "X-Forwarded-Server";
        StringBuilder baseURL = new StringBuilder();
        if (req.getHeader("X-Forwarded-Proto") != null) {
            baseURL.append(req.getHeader("X-Forwarded-Proto")).append("://");
        } else {
            baseURL.append(req.getProtocol()).append("://");
        }
        if (req.getHeader("X-Forwarded-Host") != null && req.getHeader("X-Forwarded-Port") != null) {
            if (req.getHeader("X-Forwarded-Host").contains(req.getHeader("X-Forwarded-Port"))) {
                baseURL.append(req.getHeader("X-Forwarded-Host"));
            } else {
                baseURL.append(req.getHeader("X-Forwarded-Host")).append(':').append(req.getHeader("X-Forwarded-Port"));
            }
        } else if (req.getHeader("X-Forwarded-Server") != null && req.getHeader("X-Forwarded-Port") != null) {
            baseURL.append(req.getHeader("X-Forwarded-Server")).append(':').append(req.getHeader("X-Forwarded-Port"));
        } else if (req.getHeader("X-Forwarded-Port") != null) {
            baseURL.append(req.getServerName()).append(':').append(req.getHeader("X-Forwarded-Port"));
        } else {
            baseURL.append(req.getServerName()).append(':').append(req.getLocalPort());
        }
        if (req.getHeader("X-Forwarded-Context") != null) {
            baseURL.append(req.getHeader("X-Forwarded-Context"));
        } else {
            baseURL.append(req.getContextPath());
        }
        return baseURL.toString();
    }

    static {
        mediaTypeFileExtensions.put(MediaType.APPLICATION_XML_TYPE, XML_EXT);
        mediaTypeFileExtensions.put(MediaType.APPLICATION_JSON_TYPE, JSON_EXT);
        mediaTypeFileExtensions.put(MediaType.TEXT_PLAIN_TYPE, YAML_EXT);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class SimpleTopologyWrapper {
        @XmlElement(name="topology")
        @XmlElementWrapper(name="topologies")
        private List<SimpleTopology> topologies = new ArrayList<SimpleTopology>();

        public List<SimpleTopology> getTopologies() {
            return this.topologies;
        }

        public void setTopologies(List<SimpleTopology> ts) {
            this.topologies = ts;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class SimpleTopology {
        @XmlElement
        private String name;
        @XmlElement
        private String timestamp;
        @XmlElement
        private String defaultServicePath;
        @XmlElement
        private String uri;
        @XmlElement
        private String href;

        public SimpleTopology() {
        }

        public SimpleTopology(org.apache.knox.gateway.topology.Topology t, String uri, String href) {
            this.name = t.getName();
            this.timestamp = Long.toString(t.getTimestamp());
            this.defaultServicePath = t.getDefaultServicePath();
            this.uri = uri;
            this.href = href;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String n) {
            this.name = n;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public void setDefaultService(String defaultServicePath) {
            this.defaultServicePath = defaultServicePath;
        }

        public String getDefaultService() {
            return this.defaultServicePath;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }
    }

    static class HrefListItem {
        @JsonProperty
        String href;
        @JsonProperty
        String name;

        HrefListItem() {
        }

        HrefListItem(String href, String name) {
            this.href = href;
            this.name = name;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public String getHref() {
            return this.href;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class HrefListing {
        @JsonProperty
        String href;
        @JsonProperty
        List<HrefListItem> items;

        HrefListing() {
        }

        public void setHref(String href) {
            this.href = href;
        }

        public String getHref() {
            return this.href;
        }

        public void setItems(List<HrefListItem> items) {
            this.items = items;
        }

        public List<HrefListItem> getItems() {
            return this.items;
        }
    }

    private static class TopologyComparator
    implements Comparator<SimpleTopology> {
        private TopologyComparator() {
        }

        @Override
        public int compare(SimpleTopology t1, SimpleTopology t2) {
            return t1.getName().compareTo(t2.getName());
        }
    }
}

