/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiMapEntry;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="A host endPoint for a service.")
public class ApiEndPointHost {
    @SerializedName(value="uri")
    private String uri = null;
    @SerializedName(value="endPointConfigs")
    private List<ApiMapEntry> endPointConfigs = null;
    @SerializedName(value="type")
    private String type = null;

    public ApiEndPointHost uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Schema(description="Uri for the endPoint.")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public ApiEndPointHost endPointConfigs(List<ApiMapEntry> endPointConfigs) {
        this.endPointConfigs = endPointConfigs;
        return this;
    }

    public ApiEndPointHost addEndPointConfigsItem(ApiMapEntry endPointConfigsItem) {
        if (this.endPointConfigs == null) {
            this.endPointConfigs = new ArrayList<ApiMapEntry>();
        }
        this.endPointConfigs.add(endPointConfigsItem);
        return this;
    }

    @Schema(description="EndPointHost specific configs.")
    public List<ApiMapEntry> getEndPointConfigs() {
        return this.endPointConfigs;
    }

    public void setEndPointConfigs(List<ApiMapEntry> endPointConfigs) {
        this.endPointConfigs = endPointConfigs;
    }

    public ApiEndPointHost type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="Get endPointHost type.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiEndPointHost apiEndPointHost = (ApiEndPointHost)o;
        return Objects.equals(this.uri, apiEndPointHost.uri) && Objects.equals(this.endPointConfigs, apiEndPointHost.endPointConfigs) && Objects.equals(this.type, apiEndPointHost.type);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.endPointConfigs, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiEndPointHost {\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    endPointConfigs: ").append(this.toIndentedString(this.endPointConfigs)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

