/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.json;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.status.StatusConfiguration;
import org.apache.logging.log4j.kit.json.JsonReader;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.model.PluginType;
import org.apache.logging.log4j.util.Cast;

public class JsonConfiguration
extends AbstractConfiguration
implements Reconfigurable {
    private final List<Status> statuses = new ArrayList<Status>();
    private Map<String, Object> root;

    public JsonConfiguration(LoggerContext loggerContext, ConfigurationSource configurationSource) {
        super(loggerContext, configurationSource);
        try {
            byte[] bytes;
            try (InputStream configStream = configurationSource.getInputStream();){
                bytes = configStream.readAllBytes();
                this.root = (Map)Cast.cast((Object)JsonReader.read((String)new String(bytes, StandardCharsets.UTF_8)));
            }
            if (this.root.size() == 1) {
                for (Object e : this.root.values()) {
                    this.root = (Map)Cast.cast(e);
                }
            }
            JsonConfiguration.processAttributes(this.rootNode, this.root);
            StatusConfiguration statusConfig = new StatusConfiguration().setStatus(this.getDefaultStatus());
            AtomicInteger atomicInteger = new AtomicInteger();
            this.rootNode.getAttributes().forEach((key, value) -> {
                if ("status".equalsIgnoreCase((String)key)) {
                    statusConfig.setStatus((String)value);
                } else if ("dest".equalsIgnoreCase((String)key)) {
                    statusConfig.setDestination((String)value);
                } else if ("shutdownHook".equalsIgnoreCase((String)key)) {
                    this.isShutdownHookEnabled = !"disable".equalsIgnoreCase((String)value);
                } else if ("shutdownTimeout".equalsIgnoreCase((String)key)) {
                    this.shutdownTimeoutMillis = Long.parseLong(value);
                } else if ("verbose".equalsIgnoreCase((String)key)) {
                    statusConfig.setVerbosity((String)value);
                } else if ("packages".equalsIgnoreCase((String)key)) {
                    LOGGER.warn("The packages attribute is no longer supported");
                } else if ("name".equalsIgnoreCase((String)key)) {
                    this.setName((String)value);
                } else if ("monitorInterval".equalsIgnoreCase((String)key)) {
                    monitorIntervalSeconds.setOpaque(Integer.parseInt(value));
                } else if ("advertiser".equalsIgnoreCase((String)key)) {
                    this.createAdvertiser((String)value, configurationSource, bytes, "application/json");
                }
            });
            this.initializeWatchers(this, configurationSource, atomicInteger.getOpaque());
            statusConfig.initialize();
            if (this.getName() == null) {
                this.setName(configurationSource.getLocation());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing {}", (Object)configurationSource.getLocation(), (Object)e);
        }
    }

    @Override
    public void setup() {
        List children = this.rootNode.getChildren();
        this.root.forEach((key, value) -> {
            if (value instanceof Map) {
                LOGGER.debug("Processing node for object {}", key);
                children.add(this.constructNode((String)key, this.rootNode, (Map)Cast.cast((Object)value)));
            }
        });
        LOGGER.debug("Completed parsing configuration");
        if (this.statuses.size() > 0) {
            for (Status s : this.statuses) {
                LOGGER.error("Error processing element {}: {}", (Object)s.name, (Object)s.errorType);
            }
        }
    }

    private Node constructNode(String key, Node parent, Map<String, Object> value) {
        PluginType pluginType = this.corePlugins.get(key);
        Node node = new Node(parent, key, pluginType);
        JsonConfiguration.processAttributes(node, value);
        int size = node.getChildren().size();
        value.forEach((k, v) -> {
            if (JsonConfiguration.isValueType(v)) {
                LOGGER.debug("Node {} is of type {}", k, v != null ? v.getClass() : null);
                return;
            }
            if (pluginType == null) {
                this.statuses.add(new Status(v, (String)k, ErrorType.CLASS_NOT_FOUND));
                return;
            }
            if (v instanceof List) {
                LOGGER.debug("Processing node for array {}", k);
                ((List)v).forEach(object -> {
                    if (object instanceof Map) {
                        Map map = (Map)Cast.cast((Object)object);
                        String type = JsonConfiguration.getType(map).orElse((String)k);
                        PluginType entryType = this.corePlugins.get(type);
                        Node child = new Node(node, k, entryType);
                        JsonConfiguration.processAttributes(child, map);
                        if (type.equalsIgnoreCase((String)k)) {
                            LOGGER.debug("Processing {}[{}]", k, (Object)size);
                        } else {
                            LOGGER.debug("Processing {} {}[{}]", (Object)type, k, (Object)size);
                        }
                        map.forEach((itemKey, itemValue) -> {
                            if (itemValue instanceof Map) {
                                LOGGER.debug("Processing node for object {}", itemKey);
                                child.addChild(this.constructNode((String)itemKey, child, (Map)Cast.cast((Object)itemValue)));
                            } else if (itemValue instanceof List) {
                                List list = (List)itemValue;
                                LOGGER.debug("Processing array for object {}", itemKey);
                                list.forEach(subValue -> child.addChild(this.constructNode((String)itemKey, child, (Map)Cast.cast((Object)subValue))));
                            }
                        });
                        node.addChild(child);
                    }
                });
            } else {
                LOGGER.debug("Processing node for object {}", k);
                node.addChild(this.constructNode((String)k, node, (Map)Cast.cast((Object)v)));
            }
        });
        Object t = pluginType == null ? "null" : pluginType.getElementType() + ":" + pluginType.getPluginClass();
        String p = node.getParent() == null ? "null" : (node.getParent().getName() == null ? "root" : node.getParent().getName());
        LOGGER.debug("Returning {} with parent {} of type {}", (Object)node.getName(), (Object)p, t);
        return node;
    }

    @Override
    public Configuration reconfigure() {
        try {
            ConfigurationSource configurationSource = this.getConfigurationSource().resetInputStream();
            if (configurationSource == null) {
                return null;
            }
            return new JsonConfiguration(this.getLoggerContext(), configurationSource);
        }
        catch (IOException e) {
            LOGGER.error("Cannot locate file {}", (Object)this.getConfigurationSource(), (Object)e);
            return null;
        }
    }

    private static boolean isValueType(Object value) {
        return !(value instanceof Map) && !(value instanceof List);
    }

    private static void processAttributes(Node parent, Map<String, Object> node) {
        Map attributes = parent.getAttributes();
        node.forEach((key, value) -> {
            if (!key.equalsIgnoreCase("type") && JsonConfiguration.isValueType(value)) {
                attributes.put(key, String.valueOf(value));
            }
        });
    }

    private static Optional<String> getType(Map<String, Object> node) {
        for (Map.Entry<String, Object> entry : node.entrySet()) {
            Object value;
            if (!entry.getKey().equalsIgnoreCase("type") || !JsonConfiguration.isValueType(value = entry.getValue())) continue;
            return Optional.of(String.valueOf(value));
        }
        return Optional.empty();
    }

    private static final class Status {
        private final Object node;
        private final String name;
        private final ErrorType errorType;

        private Status(Object node, String name, ErrorType errorType) {
            this.node = node;
            this.name = name;
            this.errorType = errorType;
        }

        public String toString() {
            return "Status{node=" + this.node + ", name='" + this.name + "', errorType=" + this.errorType + "}";
        }
    }

    private static enum ErrorType {
        CLASS_NOT_FOUND;

    }
}

