/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Cast;

public abstract class AbstractLayout
implements StringLayout {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    protected static final Logger LOGGER = StatusLogger.getLogger();
    protected final Configuration configuration;
    protected final Charset charset;
    protected long eventCount;
    protected final byte[] footer;
    protected final byte[] header;

    public AbstractLayout(Configuration configuration, Charset charset, byte[] header, byte[] footer) {
        this.configuration = Objects.requireNonNull(configuration, "configuration");
        this.charset = charset != null ? charset : DEFAULT_CHARSET;
        this.header = header;
        this.footer = footer;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Map<String, String> getContentFormat() {
        return Map.of();
    }

    @Override
    public byte[] getFooter() {
        return this.footer;
    }

    @Override
    public byte[] getHeader() {
        return this.header;
    }

    protected void markEvent() {
        ++this.eventCount;
    }

    @Override
    public void encode(LogEvent event, ByteBufferDestination destination) {
        byte[] data = this.toByteArray(event);
        destination.writeBytes(data, 0, data.length);
    }

    public static abstract class Builder<B extends Builder<B>> {
        @PluginConfiguration
        private Configuration configuration;
        @PluginBuilderAttribute
        private Charset charset;
        @PluginBuilderAttribute
        private byte[] footer;
        @PluginBuilderAttribute
        private byte[] header;

        public B asBuilder() {
            return (B)((Builder)Cast.cast((Object)this));
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public byte[] getFooter() {
            return this.footer;
        }

        public byte[] getHeader() {
            return this.header;
        }

        public B setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this.asBuilder();
        }

        public B setCharset(Charset charset) {
            this.charset = charset;
            return this.asBuilder();
        }

        public B setFooter(byte[] footer) {
            this.footer = footer;
            return this.asBuilder();
        }

        public B setHeader(byte[] header) {
            this.header = header;
            return this.asBuilder();
        }
    }
}

