/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Default;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.DefaultType;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Namespace;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.NamespaceList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Order;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Root;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Detail;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.FieldDetail;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodDetail;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Reflector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;

class DetailScanner
implements Detail {
    private List methods = new LinkedList();
    private List fields = new LinkedList();
    private NamespaceList declaration;
    private Namespace namespace;
    private Annotation[] labels;
    private DefaultType override;
    private DefaultType access;
    private Order order;
    private Root root;
    private Class type;
    private String name;
    private boolean required;
    private boolean strict;

    public DetailScanner(Class clazz) {
        this(clazz, null);
    }

    public DetailScanner(Class clazz, DefaultType defaultType) {
        this.labels = clazz.getDeclaredAnnotations();
        this.override = defaultType;
        this.strict = true;
        this.type = clazz;
        this.scan(clazz);
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    @Override
    public boolean isInstantiable() {
        int n = this.type.getModifiers();
        if (Modifier.isStatic(n)) {
            return true;
        }
        return !this.type.isMemberClass();
    }

    @Override
    public Root getRoot() {
        return this.root;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public DefaultType getOverride() {
        return this.override;
    }

    @Override
    public DefaultType getAccess() {
        if (this.override != null) {
            return this.override;
        }
        return this.access;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public NamespaceList getNamespaceList() {
        return this.declaration;
    }

    @Override
    public List getMethods() {
        return this.methods;
    }

    @Override
    public List getFields() {
        return this.fields;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.labels;
    }

    @Override
    public Constructor[] getConstructors() {
        return this.type.getDeclaredConstructors();
    }

    @Override
    public Class getSuper() {
        Class clazz = this.type.getSuperclass();
        if (clazz == Object.class) {
            return null;
        }
        return clazz;
    }

    private void scan(Class clazz) {
        this.methods(clazz);
        this.fields(clazz);
        this.extract(clazz);
    }

    private void extract(Class clazz) {
        for (Annotation annotation : this.labels) {
            if (annotation instanceof Namespace) {
                this.namespace(annotation);
            }
            if (annotation instanceof NamespaceList) {
                this.scope(annotation);
            }
            if (annotation instanceof Root) {
                this.root(annotation);
            }
            if (annotation instanceof Order) {
                this.order(annotation);
            }
            if (!(annotation instanceof Default)) continue;
            this.access(annotation);
        }
    }

    private void methods(Class clazz) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            MethodDetail methodDetail = new MethodDetail(method);
            this.methods.add(methodDetail);
        }
    }

    private void fields(Class clazz) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            FieldDetail fieldDetail = new FieldDetail(field);
            this.fields.add(fieldDetail);
        }
    }

    private void root(Annotation annotation) {
        if (annotation != null) {
            String string;
            Root root = (Root)annotation;
            String string2 = string = this.type.getSimpleName();
            if (root != null) {
                string2 = root.name();
                if (this.isEmpty(string2)) {
                    string2 = Reflector.getName(string);
                }
                this.strict = root.strict();
                this.root = root;
                this.name = string2;
            }
        }
    }

    private boolean isEmpty(String string) {
        return string.length() == 0;
    }

    private void order(Annotation annotation) {
        if (annotation != null) {
            this.order = (Order)annotation;
        }
    }

    private void access(Annotation annotation) {
        if (annotation != null) {
            Default default_ = (Default)annotation;
            this.required = default_.required();
            this.access = default_.value();
        }
    }

    private void namespace(Annotation annotation) {
        if (annotation != null) {
            this.namespace = (Namespace)annotation;
        }
    }

    private void scope(Annotation annotation) {
        if (annotation != null) {
            this.declaration = (NamespaceList)annotation;
        }
    }

    public String toString() {
        return this.type.toString();
    }
}

