/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Context;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Converter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Entry;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PersistenceException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Primitive;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PrimitiveFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.InputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.OutputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Style;

class PrimitiveKey
implements Converter {
    private final PrimitiveFactory factory;
    private final Context context;
    private final Primitive root;
    private final Style style;
    private final Entry entry;
    private final Type type;

    public PrimitiveKey(Context context, Entry entry, Type type) {
        this.factory = new PrimitiveFactory(context, type);
        this.root = new Primitive(context, type);
        this.style = context.getStyle();
        this.context = context;
        this.entry = entry;
        this.type = type;
    }

    @Override
    public Object read(InputNode inputNode) {
        Class clazz = this.type.getType();
        String string = this.entry.getKey();
        if (string == null) {
            string = this.context.getName(clazz);
        }
        if (!this.entry.isAttribute()) {
            return this.readElement(inputNode, string);
        }
        return this.readAttribute(inputNode, string);
    }

    @Override
    public Object read(InputNode inputNode, Object object) {
        Class clazz = this.type.getType();
        if (object != null) {
            throw new PersistenceException("Can not read key of %s for %s", clazz, this.entry);
        }
        return this.read(inputNode);
    }

    private Object readAttribute(InputNode inputNode, String string) {
        String string2 = this.style.getAttribute(string);
        InputNode inputNode2 = inputNode.getAttribute(string2);
        if (inputNode2 == null) {
            return null;
        }
        return this.root.read(inputNode2);
    }

    private Object readElement(InputNode inputNode, String string) {
        String string2 = this.style.getElement(string);
        InputNode inputNode2 = inputNode.getNext(string2);
        if (inputNode2 == null) {
            return null;
        }
        return this.root.read(inputNode2);
    }

    @Override
    public boolean validate(InputNode inputNode) {
        Class clazz = this.type.getType();
        String string = this.entry.getKey();
        if (string == null) {
            string = this.context.getName(clazz);
        }
        if (!this.entry.isAttribute()) {
            return this.validateElement(inputNode, string);
        }
        return this.validateAttribute(inputNode, string);
    }

    private boolean validateAttribute(InputNode inputNode, String string) {
        String string2 = this.style.getElement(string);
        InputNode inputNode2 = inputNode.getAttribute(string2);
        if (inputNode2 == null) {
            return true;
        }
        return this.root.validate(inputNode2);
    }

    private boolean validateElement(InputNode inputNode, String string) {
        String string2 = this.style.getElement(string);
        InputNode inputNode2 = inputNode.getNext(string2);
        if (inputNode2 == null) {
            return true;
        }
        return this.root.validate(inputNode2);
    }

    @Override
    public void write(OutputNode outputNode, Object object) {
        if (!this.entry.isAttribute()) {
            this.writeElement(outputNode, object);
        } else if (object != null) {
            this.writeAttribute(outputNode, object);
        }
    }

    private void writeElement(OutputNode outputNode, Object object) {
        Class clazz = this.type.getType();
        String string = this.entry.getKey();
        if (string == null) {
            string = this.context.getName(clazz);
        }
        String string2 = this.style.getElement(string);
        OutputNode outputNode2 = outputNode.getChild(string2);
        if (object != null && !this.isOverridden(outputNode2, object)) {
            this.root.write(outputNode2, object);
        }
    }

    private void writeAttribute(OutputNode outputNode, Object object) {
        Class clazz = this.type.getType();
        String string = this.factory.getText(object);
        String string2 = this.entry.getKey();
        if (string2 == null) {
            string2 = this.context.getName(clazz);
        }
        String string3 = this.style.getAttribute(string2);
        if (string != null) {
            outputNode.setAttribute(string3, string);
        }
    }

    private boolean isOverridden(OutputNode outputNode, Object object) {
        return this.factory.setOverride(this.type, object, outputNode);
    }
}

