/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.ValidScope;
import org.apache.velocity.tools.generic.ValueParser;
import org.apache.velocity.tools.view.ViewImportSupport;

@DefaultKey(value="json")
@ValidScope(value={"request"})
public class JsonTool
extends org.apache.velocity.tools.generic.JsonTool {
    private static final long serialVersionUID = -4305396131049004070L;

    protected synchronized void initializeImportSupport(ValueParser config) {
        if (this.importSupport == null) {
            this.importSupport = new ViewImportSupport();
            this.importSupport.configure((Map)config);
        }
    }

    protected static boolean isJsonMimeType(String mimeType) {
        return mimeType != null && ("text/json".equals(mimeType) || "application/json".equals(mimeType) || mimeType.endsWith("+json"));
    }

    protected static boolean isJsonContentType(String contentType) {
        if (contentType != null) {
            int sep = contentType.indexOf(59);
            String mimeType = sep == -1 ? contentType : contentType.substring(0, sep).trim();
            return JsonTool.isJsonMimeType(mimeType);
        }
        return false;
    }

    protected void configure(ValueParser parser) {
        ServletRequest request;
        super.configure(parser);
        if (this.root() == null && (request = (ServletRequest)parser.get("request")).getContentLength() > 0 && JsonTool.isJsonContentType(request.getContentType())) {
            try {
                this.initJSON(request.getReader());
            }
            catch (Exception e) {
                this.getLog().error("could not parse JSON object", (Throwable)e);
            }
        }
    }
}

