/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.tools.ClassUtils;
import org.apache.velocity.tools.view.BrowserTool;
import org.slf4j.Logger;

public class UAParser {
    private static Map<String, String> browserTranslationMap = null;
    private static Map<String, String> osTranslationMap = null;
    private static final String UA_KEYWORDS = "/org/apache/velocity/tools/view/ua-keywords.txt";
    private static Map<String, Pair<EntityType, DeviceType>> entityMap;
    private static final String nonMergeSep = "(;/)";
    private static Pattern versionPattern;

    private static boolean isRobotToken(String token) {
        return (token = token.toLowerCase()).endsWith("bot") || token.endsWith("crawler") || token.endsWith("spider") || token.endsWith("agent") || token.endsWith("validator");
    }

    public static UserAgent parseUserAgent(String userAgentString, Logger log) {
        UserAgent ua = null;
        try {
            ua = new UserAgent();
            Matcher matcher = versionPattern.matcher(userAgentString);
            String merge = null;
            Enum mergeTarget = null;
            boolean maybeBrowser = true;
            boolean maybeOS = true;
            boolean maybeRobot = false;
            boolean forcedBrowser = false;
            boolean forcedOS = false;
            block22: while (matcher.find()) {
                int next;
                String entity = matcher.group(1);
                String separator = matcher.group(2);
                String major = matcher.group(3);
                String minor = matcher.group(4);
                int n = next = userAgentString.length() == matcher.end(1) ? 59 : (int)userAgentString.charAt(matcher.end(1));
                if (entity == null) continue;
                if (merge != null) {
                    String merged = merge + " " + entity;
                    if (mergeTarget == null) {
                        entity = merged;
                    } else {
                        EntityType mergedType;
                        Pair<EntityType, DeviceType> pair = entityMap.get(merged.toLowerCase());
                        EntityType entityType = mergedType = pair == null ? null : (EntityType)((Object)pair.getLeft());
                        if (mergedType != null && (mergeTarget == mergedType || mergeTarget == EntityType.BROWSER && (mergedType == EntityType.MAYBE_BROWSER || mergedType == EntityType.FORCE_BROWSER) || mergeTarget == EntityType.OS && (mergedType == EntityType.MAYBE_OS || mergedType == EntityType.FORCE_OS))) {
                            entity = merged;
                        } else {
                            switch (1.$SwitchMap$org$apache$velocity$tools$view$UAParser$EntityType[mergeTarget.ordinal()]) {
                                case 1: {
                                    ua.setBrowser(merge, null, null);
                                    break;
                                }
                                case 2: {
                                    ua.setOperatingSystem(merge, null, null);
                                    break;
                                }
                                default: {
                                    throw new VelocityException("BrowserTool: unhandled case!");
                                }
                            }
                        }
                    }
                    merge = null;
                    mergeTarget = null;
                }
                Pair<EntityType, DeviceType> identity = entityMap.get(entity.toLowerCase());
                EntityType entityType = null;
                DeviceType deviceType = null;
                if (identity == null) {
                    String alternateEntity = entity + separator + major;
                    identity = entityMap.get((entity + separator + major).toLowerCase());
                    if (identity != null) {
                        entity = alternateEntity;
                    }
                }
                if (identity != null) {
                    entityType = (EntityType)((Object)identity.getLeft());
                    deviceType = (DeviceType)((Object)identity.getRight());
                    DeviceType previousDeviceType = ua.getDeviceType();
                    if (deviceType != null && (previousDeviceType == null || deviceType.compareTo(previousDeviceType) > 0)) {
                        ua.setDeviceType(deviceType);
                    }
                }
                if (entityType != null) {
                    switch (entityType) {
                        case BROWSER: {
                            if (ua.getBrowser() != null && forcedBrowser) continue block22;
                            ua.setBrowser(entity, major, minor);
                            maybeBrowser = false;
                            continue block22;
                        }
                        case BROWSER_OS: {
                            ua.setBrowser(entity, major, minor);
                            maybeBrowser = false;
                            ua.setOperatingSystem(entity, major, minor);
                            maybeOS = false;
                            continue block22;
                        }
                        case ENGINE: {
                            if ("KHTML".equals(entity) && major == null && ua.getRenderingEngine() != null) continue block22;
                            ua.setRenderingEngine(entity, major, minor);
                            continue block22;
                        }
                        case FORCE_BROWSER: {
                            if (forcedBrowser) continue block22;
                            ua.setBrowser(entity, major, minor);
                            maybeBrowser = false;
                            forcedBrowser = true;
                            continue block22;
                        }
                        case FORCE_OS: {
                            if (forcedOS) continue block22;
                            ua.setOperatingSystem(entity, major, minor);
                            maybeOS = false;
                            forcedOS = true;
                            continue block22;
                        }
                        case IGNORE: {
                            continue block22;
                        }
                        case MAYBE_BROWSER: {
                            if (!maybeBrowser) continue block22;
                            if ("rv".equals(entity)) {
                                entity = ua.getBrowser() != null && ua.getBrowser().getName().equals("Mozilla") ? "Mozilla" : null;
                            } else if ("Version".equals(entity)) {
                                entity = ua.getBrowser() != null && ua.getBrowser().getName().startsWith("Opera") ? ua.getBrowser().getName() : (ua.getBrowser() != null && ua.getBrowser().getName().equals("Mozilla") ? "Safari" : null);
                            } else if ("Safari".equals(entity) && ua.getBrowser() != null && "Safari".equals(ua.getBrowser().getName())) {
                                entity = null;
                            }
                            if (entity == null) continue block22;
                            ua.setBrowser(entity, major, minor);
                            continue block22;
                        }
                        case MAYBE_OS: {
                            if (!maybeOS) continue block22;
                            ua.setOperatingSystem(entity, major, minor);
                            continue block22;
                        }
                        case MAYBE_ROBOT: {
                            maybeRobot = true;
                            continue block22;
                        }
                        case MERGE: {
                            if (major != null) continue block22;
                            if (nonMergeSep.indexOf(next) == -1) {
                                merge = merge == null ? entity : merge + " " + entity;
                                continue block22;
                            }
                            if (!"Mobile".equals(entity) || ua.getOperatingSystem() == null) continue block22;
                            if (ua.getOperatingSystem().getName().equals("Ubuntu")) {
                                ua.setOperatingSystem("Ubuntu Mobile", String.valueOf(ua.getOperatingSystem().getMajorVersion()), String.valueOf(ua.getOperatingSystem().getMinorVersion()));
                                continue block22;
                            }
                            if (!ua.getOperatingSystem().getName().equals("Linux")) continue block22;
                            ua.setOperatingSystem("Android", null, null);
                            continue block22;
                        }
                        case MERGE_OR_BROWSER: {
                            if (forcedBrowser) continue block22;
                            if (major != null || nonMergeSep.indexOf(next) != -1) {
                                ua.setBrowser(entity, major, minor);
                                continue block22;
                            }
                            merge = entity;
                            mergeTarget = EntityType.BROWSER;
                            continue block22;
                        }
                        case MERGE_OR_OS: {
                            if (forcedOS) continue block22;
                            if (major != null || nonMergeSep.indexOf(next) != -1) {
                                ua.setOperatingSystem(entity, major, minor);
                                continue block22;
                            }
                            merge = entity;
                            mergeTarget = EntityType.OS;
                            continue block22;
                        }
                        case OS: {
                            if (ua.getOperatingSystem() != null && forcedOS) continue block22;
                            ua.setOperatingSystem(entity, major, minor);
                            maybeOS = false;
                            continue block22;
                        }
                        case ROBOT: {
                            ua.setDeviceType(DeviceType.ROBOT);
                            continue block22;
                        }
                    }
                    throw new VelocityException("BrowserTool: unhandled case: " + (Object)((Object)entityType));
                }
                if (entity.startsWith("Linux") && !forcedOS) {
                    ua.setOperatingSystem("Linux", null, null);
                    continue;
                }
                if (UAParser.isRobotToken(entity)) {
                    ua.setDeviceType(DeviceType.ROBOT);
                    continue;
                }
                if (entity.startsWith("MID") && !entity.startsWith("MIDP") && (ua.getDeviceType() == null || DeviceType.TABLET.compareTo(ua.getDeviceType()) > 0)) {
                    ua.setDeviceType(DeviceType.TABLET);
                    continue;
                }
                if (entity.startsWith("CoolPad") && (ua.getDeviceType() == null || DeviceType.MOBILE.compareTo(ua.getDeviceType()) > 0)) {
                    ua.setDeviceType(DeviceType.MOBILE);
                    continue;
                }
                if (entity.startsWith("LG-") && (ua.getDeviceType() == null || DeviceType.MOBILE.compareTo(ua.getDeviceType()) > 0)) {
                    ua.setDeviceType(DeviceType.MOBILE);
                    continue;
                }
                if (!entity.startsWith("SonyEricsson")) continue;
                ua.setDeviceType(DeviceType.MOBILE);
            }
            if (ua.getOperatingSystem() != null && "Windows".equals(ua.getOperatingSystem().getName()) && (ua.getOperatingSystem().getMajorVersion() == 98 || ua.getOperatingSystem().getMajorVersion() == 2000)) {
                if (ua.getOperatingSystem().getMajorVersion() == 98) {
                    ua.setOperatingSystem("Windows 98", "4", "90");
                } else if (ua.getOperatingSystem().getMajorVersion() == 2000) {
                    ua.setOperatingSystem("Windows 2000", "5", "0");
                }
            }
            if (ua.getBrowser() == null) {
                if (ua.getDeviceType() == DeviceType.ROBOT || maybeRobot) {
                    ua.setBrowser("robot", "0", "0");
                    ua.setDeviceType(DeviceType.ROBOT);
                } else if (ua.getOperatingSystem() != null && ua.getOperatingSystem().getName().equals("Symbian")) {
                    ua.setBrowser("Nokia Browser", String.valueOf(ua.getOperatingSystem().getMajorVersion()), String.valueOf(ua.getOperatingSystem().getMinorVersion()));
                } else {
                    ua.setBrowser("unknown", "0", "0");
                }
            }
            if (ua.getOperatingSystem() == null) {
                if (ua.getDeviceType() == DeviceType.ROBOT || maybeRobot) {
                    ua.setOperatingSystem("robot", "0", "0");
                    ua.setDeviceType(DeviceType.ROBOT);
                } else {
                    ua.setOperatingSystem("unknown", "0", "0");
                }
            }
            if (ua.getDeviceType() == null) {
                if (ua.getOperatingSystem() != null && "Android".equals(ua.getOperatingSystem().getName())) {
                    ua.setDeviceType(DeviceType.MOBILE);
                } else {
                    ua.setDeviceType(DeviceType.DESKTOP);
                }
            }
        }
        catch (Exception e) {
            log.error("Could not parse browser for User-Agent: {}", (Object)userAgentString, (Object)e);
            ua = null;
        }
        return ua;
    }

    static {
        browserTranslationMap = new HashMap<String, String>();
        browserTranslationMap.put("navigator", "Netscape");
        browserTranslationMap.put("nokia5250", "Nokia Browser");
        osTranslationMap = new HashMap<String, String>();
        osTranslationMap.put("android", "Android");
        osTranslationMap.put("bada", "Bada");
        osTranslationMap.put("bb10", "BlackBerry");
        osTranslationMap.put("blackberry", "BlackBerry");
        osTranslationMap.put("cros", "Chrome OS");
        osTranslationMap.put("fxos", "Firefox OS");
        osTranslationMap.put("hpwos", "WebOS");
        osTranslationMap.put("ipad", "iOS");
        osTranslationMap.put("iphone", "iOS");
        osTranslationMap.put("ipod", "iOS");
        osTranslationMap.put("kfthwi", "Kindle");
        osTranslationMap.put("kftt", "Kindle");
        osTranslationMap.put("mac os x", "OS X");
        osTranslationMap.put("macos x", "OS X");
        osTranslationMap.put("nokiae", "Nokia");
        osTranslationMap.put("nokiax2", "Nokia");
        osTranslationMap.put("remi", "Fedora");
        osTranslationMap.put("rhel", "Red Hat");
        osTranslationMap.put("series40", "Symbian");
        osTranslationMap.put("series60", "Symbian");
        osTranslationMap.put("series80", "Symbian");
        osTranslationMap.put("series90", "Symbian");
        osTranslationMap.put("series 40", "Symbian");
        osTranslationMap.put("series 60", "Symbian");
        osTranslationMap.put("series 80", "Symbian");
        osTranslationMap.put("series 90", "Symbian");
        osTranslationMap.put("symbianos", "Symbian");
        osTranslationMap.put("symbos", "Symbian");
        osTranslationMap.put("tigeros", "OS X");
        osTranslationMap.put("tizen", "Tizen");
        osTranslationMap.put("tt", "Android");
        osTranslationMap.put("unix", "Unix");
        osTranslationMap.put("unix bsd", "BSD");
        osTranslationMap.put("unixware", "Unix");
        osTranslationMap.put("webos", "WebOS");
        osTranslationMap.put("windows nt", "Windows");
        osTranslationMap.put("win98", "Windows");
        entityMap = new HashMap<String, Pair<EntityType, DeviceType>>();
        try {
            Properties properties = new Properties();
            InputStream stream = ClassUtils.getResourceAsStream((String)UA_KEYWORDS, BrowserTool.class);
            if (stream == null) {
                throw new IOException("could not find org.apache.velocity.tools.view.ua-keywords.txt resource");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = null;
            int num = 1;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
                    ++num;
                    continue;
                }
                int eq = line.indexOf(61);
                if (eq == -1) {
                    throw new IOException("invalid line format in ua-keywords.txt at line " + num);
                }
                String key = line.substring(0, eq);
                String val = line.substring(eq + 1).toUpperCase();
                int coma = val.indexOf(44);
                DeviceType device = null;
                if (coma != -1) {
                    device = DeviceType.valueOf(val.substring(coma + 1));
                    val = val.substring(0, coma);
                }
                EntityType entity = val.length() > 0 ? EntityType.valueOf(val) : null;
                entityMap.put(key, (Pair<EntityType, DeviceType>)new ImmutablePair((Object)entity, (Object)device));
                ++num;
            }
        }
        catch (Exception e) {
            throw new VelocityException("BrowserTool: static initialization failed", (Throwable)e);
        }
        versionPattern = Pattern.compile("([a-z]+(?:(?=[;()@]|$)|(?:[0-9]+(?!\\.)[a-z]*)|(?:[!_+.\\-][a-z]+)+|(?=[/ ,\\-:0-9+!_=])))(?:([/ ,\\-:+_=])?(?:v?(\\d+)(?:\\.(\\d+))?[a-z+]*)?)", 2);
    }

    private static enum EntityType {
        BROWSER,
        BROWSER_OS,
        ENGINE,
        FORCE_BROWSER,
        FORCE_OS,
        IGNORE,
        MAYBE_BROWSER,
        MAYBE_OS,
        MAYBE_ROBOT,
        MERGE,
        MERGE_OR_BROWSER,
        MERGE_OR_OS,
        OS,
        ROBOT;

    }

    public static class UserAgent
    implements Serializable {
        private static final long serialVersionUID = 2295189396414933725L;
        private DeviceType deviceType = null;
        private UAEntity operatingSystem = null;
        private UAEntity browser = null;
        private UAEntity renderingEngine = null;
        private boolean isRobot = false;

        public DeviceType getDeviceType() {
            return this.deviceType;
        }

        public UAEntity getOperatingSystem() {
            return this.operatingSystem;
        }

        public UAEntity getBrowser() {
            return this.browser;
        }

        public UAEntity getRenderingEngine() {
            return this.renderingEngine;
        }

        protected void setOperatingSystem(String entity, String major, String minor) {
            String alternate;
            if (entity.equals("Series") && major != null) {
                entity = entity + major;
                minor = null;
                major = null;
            }
            if ((alternate = (String)osTranslationMap.get(entity.toLowerCase())) != null) {
                entity = alternate;
            }
            if (entity.startsWith("BlackBerry")) {
                entity = "BlackBerry";
            }
            this.operatingSystem = new UAEntity(entity, major, minor);
        }

        protected void setBrowser(String entity, String major, String minor) {
            String alternate = (String)browserTranslationMap.get(entity.toLowerCase());
            if (alternate != null) {
                entity = alternate;
            }
            if ("Navigator".equals(entity)) {
                entity = "Netscape";
            }
            this.browser = new UAEntity(entity, major, minor, true);
            if ("Edge".equals(entity) && this.renderingEngine == null) {
                this.renderingEngine = new UAEntity("EdgeHTML", major, minor);
            }
        }

        protected void setRenderingEngine(String entity, String major, String minor) {
            if (this.deviceType == DeviceType.ROBOT) {
                return;
            }
            this.renderingEngine = new UAEntity(entity, major, minor);
        }

        protected void setDeviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
        }
    }

    public static enum DeviceType {
        UNKNOWN,
        DESKTOP,
        MOBILE,
        TABLET,
        TV,
        ROBOT;

    }

    public static class UAEntity
    implements Serializable {
        private static final long serialVersionUID = 5148646199164619995L;
        private String name = null;
        private int majorVersion = -1;
        private int minorVersion = -1;

        public UAEntity(String n, String maj, String min) {
            this(n, maj, min, false);
        }

        public UAEntity(String n, String maj, String min, boolean wantsFullVersion) {
            this.name = n;
            try {
                this.majorVersion = maj == null ? -1 : Integer.valueOf(maj);
                try {
                    this.minorVersion = maj == null ? -1 : Integer.valueOf(min);
                }
                catch (NumberFormatException nfe) {
                    this.minorVersion = -1;
                    if (wantsFullVersion) {
                        this.majorVersion = -1;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                this.minorVersion = -1;
                this.majorVersion = -1;
            }
        }

        public String getName() {
            return this.name;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }
    }
}

