/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.netty;

import io.netty.channel.group.ChannelGroup;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.netty.NettyIoServiceFactory;

public abstract class NettyIoService
extends AbstractCloseable
implements IoService {
    public static final AttributeKey<IoConnectFuture> CONNECT_FUTURE_KEY = AttributeKey.valueOf((String)IoConnectFuture.class.getName());
    protected final AtomicLong sessionSeq = new AtomicLong();
    protected final Map<Long, IoSession> sessions = new ConcurrentHashMap<Long, IoSession>();
    protected ChannelGroup channelGroup;
    protected final NettyIoServiceFactory factory;
    protected final IoHandler handler;
    private IoServiceEventListener eventListener;

    protected NettyIoService(NettyIoServiceFactory factory, IoHandler handler) {
        this.factory = Objects.requireNonNull(factory, "No factory instance provided");
        this.handler = Objects.requireNonNull(handler, "No I/O handler provied");
        this.eventListener = factory.getIoServiceEventListener();
    }

    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    public void setIoServiceEventListener(IoServiceEventListener listener) {
        this.eventListener = listener;
    }

    public Map<Long, IoSession> getManagedSessions() {
        return this.sessions;
    }
}

