/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.hooks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import org.eclipse.jgit.api.errors.AbortedByHookException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.io.TeeOutputStream;

public abstract class GitHook<T>
implements Callable<T> {
    private final Repository repo;
    private final OutputStream outputStream;
    private final OutputStream errorStream;

    protected GitHook(Repository repo, OutputStream outputStream) {
        this(repo, outputStream, null);
    }

    protected GitHook(Repository repo, OutputStream outputStream, OutputStream errorStream) {
        this.repo = repo;
        this.outputStream = outputStream;
        this.errorStream = errorStream;
    }

    @Override
    public abstract T call() throws IOException, AbortedByHookException;

    public abstract String getHookName();

    protected Repository getRepository() {
        return this.repo;
    }

    protected String[] getParameters() {
        return new String[0];
    }

    protected String getStdinArgs() {
        return null;
    }

    protected OutputStream getOutputStream() {
        return this.outputStream == null ? System.out : this.outputStream;
    }

    protected OutputStream getErrorStream() {
        return this.errorStream == null ? System.err : this.errorStream;
    }

    protected void doRun() throws AbortedByHookException, IOException {
        ProcessResult result;
        ByteArrayOutputStream errorByteArray = new ByteArrayOutputStream();
        TeeOutputStream stderrStream = new TeeOutputStream(errorByteArray, this.getErrorStream());
        Repository repository = this.getRepository();
        FS fs = repository.getFS();
        if (fs == null) {
            fs = FS.DETECTED;
        }
        if ((result = fs.runHookIfPresent(repository, this.getHookName(), this.getParameters(), this.getOutputStream(), stderrStream, this.getStdinArgs())).isExecutedWithError()) {
            this.handleError(new String(errorByteArray.toByteArray(), Charset.defaultCharset().name()), result);
        }
    }

    protected void handleError(String message, ProcessResult result) throws AbortedByHookException {
        throw new AbortedByHookException(message, this.getHookName(), result.getExitCode());
    }

    public boolean isNativeHookPresent() {
        FS fs = this.getRepository().getFS();
        if (fs == null) {
            fs = FS.DETECTED;
        }
        return fs.findHook(this.getRepository(), this.getHookName()) != null;
    }
}

