// ---------- Attention: Generated code, please do not modify! -----------

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.component;

import jakarta.el.MethodExpression;
import jakarta.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUITabGroup;
import org.apache.myfaces.tobago.model.SwitchType;
import org.apache.myfaces.tobago.renderkit.css.CustomClass;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.component.Tags;
import jakarta.annotation.Generated;
import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;

/**
 Renders a tab group which contains tab panels.
  * UIComponent class, generated from template {@code component.stg} with class
  * {@link org.apache.myfaces.tobago.internal.taglib.component.TabGroupTagDeclaration}.
 */
@Generated("component.stg")
public class UITabGroup
    extends AbstractUITabGroup  {

  private static final Tags TAG = Tags.tabGroup;

  public static final String COMPONENT_TYPE = TAG.componentType();

  public static final String COMPONENT_FAMILY = "jakarta.faces.Panel";

  private static final Collection<String> EVENT_NAMES = Arrays.asList("tobago.tabGroup.tabChange", "click");

  @Override
  public Collection<String> getEventNames() {
    return EVENT_NAMES;
  }

  @Override
  public String getDefaultEventName() {
    return "tobago.tabGroup.tabChange";
  }


  enum PropertyKeys {
    renderedIndex,
    actionListener,
    autoSpacing,
    switchType,
    tabChangeListener,
    markup,
    immediate,
    action,
    customClass,
    showNavigationBar,
    tip,
    selectedIndex,
  }

  public String getFamily() {
    return COMPONENT_FAMILY;
  }


  /**
  For internal use. TBD: Check if this is needed any longer.
  <br>Default: <code>0</code>
  */
  public java.lang.Integer getRenderedIndex() {
    Number value  = (Number) getStateHelper().eval(PropertyKeys.renderedIndex);
    if (value != null) {
      return value.intValue();
    }
    return 0;
  }

  public void setRenderedIndex(java.lang.Integer renderedIndex) {
    getStateHelper().put(PropertyKeys.renderedIndex, renderedIndex);
  }

  public jakarta.el.MethodExpression getActionListenerExpression() {
    return (jakarta.el.MethodExpression) getStateHelper().eval(PropertyKeys.actionListener);
  }

  public void setActionListenerExpression(jakarta.el.MethodExpression actionListener) {
    getStateHelper().put(PropertyKeys.actionListener, actionListener);
  }


  /**
  Automatically add spacing (margins/paddings) to the component for better positioning.
   Default is 'true' except the component is inside a:
   - header
   - footer
   - bar
   - sheet
   - tree
   - popover
   - link group
   - button group
   - before facet
   - after facet
   - label facet
   - bar facet

  */
  public Boolean getAutoSpacing() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.autoSpacing);
    if (bool != null) {
      return bool;
    }
    return null;
  }

  public void setAutoSpacing(Boolean autoSpacing) {
    getStateHelper().put(PropertyKeys.autoSpacing, autoSpacing);
  }

  /**
  <p>
   Indicating how tab switching should be done.
   </p>
   <p>
   Possible values are:
   </p>
   <dl>
     <dt>client</dt>
     <dd>Tab switching is done on client, no server Request.</dd>
     <dt>reloadPage</dt>
     <dd>Tab switching is done by server request. Full page is reloaded.</dd>
     <dt>reloadTab</dt>
     <dd>Tab switching is done by server request. Only the Tab is reloaded.</dd>
   </dl>
  <br>Default: <code>client</code><br>Allowed Values: <code>client,reloadPage,reloadTab</code>
  */
  public org.apache.myfaces.tobago.model.SwitchType getSwitchType() {
    org.apache.myfaces.tobago.model.SwitchType switchType = (org.apache.myfaces.tobago.model.SwitchType) getStateHelper().eval(PropertyKeys.switchType);
    if (switchType != null) {
      return switchType;
    }
    return org.apache.myfaces.tobago.model.SwitchType.client;
  }

  public void setSwitchType(org.apache.myfaces.tobago.model.SwitchType switchType) {
    getStateHelper().put(PropertyKeys.switchType, switchType);
  }

  public jakarta.el.MethodExpression getTabChangeListenerExpression() {
    return (jakarta.el.MethodExpression) getStateHelper().eval(PropertyKeys.tabChangeListener);
  }

  public void setTabChangeListenerExpression(jakarta.el.MethodExpression tabChangeListener) {
    getStateHelper().put(PropertyKeys.tabChangeListener, tabChangeListener);
  }


  public org.apache.myfaces.tobago.context.Markup getMarkup() {
    Object object = getStateHelper().eval(PropertyKeys.markup);
    if (object != null) {
      return Markup.valueOf(object);
    }
    return null;
  }

  public void setMarkup(org.apache.myfaces.tobago.context.Markup markup) {
    getStateHelper().put(PropertyKeys.markup, markup);
  }

  /**
  Flag indicating that, if this component is activated by the user,
   notifications should be delivered to interested listeners and actions
   immediately (that is, during Apply Request Values phase) rather than
   waiting until Invoke Application phase.
  <br>Default: <code>false</code>
  */
  public boolean isImmediate() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.immediate);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setImmediate(boolean immediate) {
    getStateHelper().put(PropertyKeys.immediate, immediate);
  }

  public jakarta.el.MethodExpression getActionExpression() {
    return (jakarta.el.MethodExpression) getStateHelper().eval(PropertyKeys.action);
  }

  public void setActionExpression(jakarta.el.MethodExpression action) {
    getStateHelper().put(PropertyKeys.action, action);
  }


  /**
  Sets a CSS class in its parent, if the parent supports it.

   Which this feature it is possible to put a CSS class name into a component with the &lt;tc:style&gt; tag. Example:

   <pre>
   &lt;tc:in&gt;
     &lt;tc:style customClass="my-emphasized"/&gt;
   &lt;/tc:in&gt;
   </pre>

   One capability is, to used external CSS libs.
   <br>
   This feature should not be used imprudent.
   Because it might be unstable against changes in the renderered HTML code.

  */
  public org.apache.myfaces.tobago.renderkit.css.CustomClass getCustomClass() {
    return (org.apache.myfaces.tobago.renderkit.css.CustomClass) getStateHelper().eval(PropertyKeys.customClass);
  }

  public void setCustomClass(org.apache.myfaces.tobago.renderkit.css.CustomClass customClass) {
    getStateHelper().put(PropertyKeys.customClass, customClass);
  }

  /**
  Flag indicating that the tab navigation bar is rendered.
  <br>Default: <code>true</code>
  */
  public boolean isShowNavigationBar() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.showNavigationBar);
    if (bool != null) {
      return bool;
    }
    return true;
  }

  public void setShowNavigationBar(boolean showNavigationBar) {
    getStateHelper().put(PropertyKeys.showNavigationBar, showNavigationBar);
  }

  /**
  Text value to display as tooltip.

  */
  public java.lang.String getTip() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.tip);
  }

  public void setTip(java.lang.String tip) {
    getStateHelper().put(PropertyKeys.tip, tip);
  }

  /**
  <strong>ValueBindingExpression</strong> pointing to a Integer to save the
   component's selected Tab.
  <br>Default: <code>0</code>
  */
  public java.lang.Integer getSelectedIndex() {
    Number value  = (Number) getStateHelper().eval(PropertyKeys.selectedIndex);
    if (value != null) {
      return value.intValue();
    }
    return 0;
  }

  public void setSelectedIndex(java.lang.Integer selectedIndex) {
    getStateHelper().put(PropertyKeys.selectedIndex, selectedIndex);
  }


  @Override
  public void restoreState(FacesContext context, Object state) {
    // FIXME HACK for mojarra SystemEventListener state restoring bug
    pushComponentToEL(context, this);
    super.restoreState(context, state);
    popComponentFromEL(context);
  }

}