/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.code;

import java.util.HashMap;
import java.util.Map;
import jpt.sun.tools.javac.code.Kinds;
import jpt.sun.tools.javac.code.Scope;
import jpt.sun.tools.javac.code.Symbol;
import jpt.sun.tools.javac.code.Type;
import jpt.sun.tools.javac.util.Context;

public class DeferredCompletionFailureHandler {
    protected static final Context.Key<DeferredCompletionFailureHandler> deferredCompletionFailureHandlerKey = new Context.Key();
    public final Handler userCodeHandler = new Handler(){
        private final Map<Symbol.ClassSymbol, FlipSymbolDescription> class2Flip = new HashMap<Symbol.ClassSymbol, FlipSymbolDescription>();

        @Override
        public void install() {
            this.class2Flip.values().forEach(f -> f.flip());
        }

        @Override
        public void handleAPICompletionFailure(Symbol.CompletionFailure cf) {
        }

        @Override
        public void classSymbolCompleteFailed(Symbol.ClassSymbol sym, Symbol.Completer origCompleter) {
            this.class2Flip.put(sym, new FlipSymbolDescription(sym, new DeferredCompleter(origCompleter){

                @Override
                public void complete(Symbol sym) throws Symbol.CompletionFailure {
                    class2Flip.remove(sym);
                    super.complete(sym);
                }
            }));
        }

        @Override
        public void classSymbolRemoved(Symbol.ClassSymbol sym) {
            this.class2Flip.remove(sym);
        }

        @Override
        public void uninstall() {
            this.class2Flip.values().forEach(f -> f.flip());
        }
    };
    public final Handler speculativeCodeHandler = new Handler(){
        private final Map<Symbol.ClassSymbol, FlipSymbolDescription> class2Flip = new HashMap<Symbol.ClassSymbol, FlipSymbolDescription>();

        @Override
        public void install() {
        }

        @Override
        public void handleAPICompletionFailure(Symbol.CompletionFailure cf) {
            throw cf;
        }

        @Override
        public void classSymbolCompleteFailed(Symbol.ClassSymbol sym, Symbol.Completer origCompleter) {
            this.class2Flip.put(sym, new FlipSymbolDescription(sym, new DeferredCompleter(origCompleter)));
        }

        @Override
        public void classSymbolRemoved(Symbol.ClassSymbol sym) {
            this.class2Flip.remove(sym);
        }

        @Override
        public void uninstall() {
            this.class2Flip.values().forEach(f -> f.flip());
            this.class2Flip.clear();
        }
    };
    public final Handler javacCodeHandler;
    private Handler handler = this.javacCodeHandler = new Handler(){

        @Override
        public void install() {
        }

        @Override
        public void handleAPICompletionFailure(Symbol.CompletionFailure cf) {
            throw cf;
        }

        @Override
        public void classSymbolCompleteFailed(Symbol.ClassSymbol sym, Symbol.Completer origCompleter) {
        }

        @Override
        public void classSymbolRemoved(Symbol.ClassSymbol sym) {
        }

        @Override
        public void uninstall() {
        }
    };

    public static DeferredCompletionFailureHandler instance(Context context) {
        DeferredCompletionFailureHandler instance = context.get(deferredCompletionFailureHandlerKey);
        if (instance == null) {
            instance = new DeferredCompletionFailureHandler(context);
        }
        return instance;
    }

    protected DeferredCompletionFailureHandler(Context context) {
        context.put(deferredCompletionFailureHandlerKey, this);
    }

    public Handler setHandler(Handler h) {
        if (h == this.handler) {
            return this.handler;
        }
        this.handler.uninstall();
        Handler prev = this.handler;
        this.handler = h;
        this.handler.install();
        return prev;
    }

    public void handleAPICompletionFailure(Symbol.CompletionFailure cf) {
        this.handler.handleAPICompletionFailure(cf);
    }

    public void classSymbolCompleteFailed(Symbol.ClassSymbol sym, Symbol.Completer origCompleter) {
        this.handler.classSymbolCompleteFailed(sym, origCompleter);
    }

    public void classSymbolRemoved(Symbol.ClassSymbol sym) {
        this.handler.classSymbolRemoved(sym);
    }

    public boolean isDeferredCompleter(Symbol.Completer c) {
        return c instanceof DeferredCompleter;
    }

    public static interface Handler {
        public void install();

        public void handleAPICompletionFailure(Symbol.CompletionFailure var1);

        public void classSymbolCompleteFailed(Symbol.ClassSymbol var1, Symbol.Completer var2);

        public void classSymbolRemoved(Symbol.ClassSymbol var1);

        public void uninstall();
    }

    private class DeferredCompleter
    implements Symbol.Completer {
        private final Symbol.Completer origCompleter;

        public DeferredCompleter(Symbol.Completer origCompleter) {
            this.origCompleter = origCompleter;
        }

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            this.origCompleter.complete(sym);
        }
    }

    private static class FlipSymbolDescription {
        public final Symbol.ClassSymbol sym;
        public Type type;
        public Kinds.Kind kind;
        public Scope.WriteableScope members;
        public Symbol.Completer completer;

        public FlipSymbolDescription(Symbol.ClassSymbol sym, Symbol.Completer completer) {
            this.sym = sym;
            this.type = sym.type;
            this.kind = sym.kind;
            this.members = null;
            this.completer = completer;
        }

        public void flip() {
            Type prevType = this.sym.type;
            this.sym.type = this.type;
            this.type = prevType;
            Kinds.Kind prevKind = this.sym.kind;
            this.sym.kind = this.kind;
            this.kind = prevKind;
            Symbol.Completer prevCompleter = this.sym.completer;
            this.sym.completer = this.completer;
            this.completer = prevCompleter;
            Scope.WriteableScope prevMembers = this.sym.members_field;
            this.sym.members_field = this.members;
            this.members = prevMembers;
        }
    }
}

