/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.openide.util.Exceptions;

public class WriteLockUtils {
    static final String PREFIX = ".LCK";
    static final String SUFFIX = "~";

    private WriteLockUtils() {
    }

    public static synchronized boolean hasActiveLockFileSigns(String filename) {
        return filename.startsWith(PREFIX) && filename.endsWith(SUFFIX);
    }

    public static synchronized boolean isActiveLockFile(File file) {
        String name = file.getName();
        boolean isActiveLockFile = WriteLockUtils.hasActiveLockFileSigns(name);
        if (isActiveLockFile) {
            String newName = name.substring(PREFIX.length(), name.length() - SUFFIX.length());
            isActiveLockFile = FileChangedManager.getInstance().exists(new File(file.getParentFile(), newName));
        }
        return isActiveLockFile;
    }

    public static File getAssociatedLockFile(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iex) {
            Exceptions.printStackTrace(iex);
        }
        File parentFile = file.getParentFile();
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIX);
        sb.append(file.getName());
        sb.append(SUFFIX);
        String lckName = sb.toString();
        File lck = new File(parentFile, lckName);
        return lck;
    }

    static String getContentOfLckFile(File lckFile, FileChannel channel) throws IOException {
        byte[] readContent = new byte[(int)lckFile.length()];
        channel.read(ByteBuffer.wrap(readContent));
        String retVal = new String(readContent);
        return FileChangedManager.getInstance().exists(new File(retVal)) ? retVal : null;
    }

    static String writeContentOfLckFile(File lck, FileChannel channel) throws IOException {
        String absolutePath = lck.getAbsolutePath();
        ByteBuffer buf = ByteBuffer.wrap(absolutePath.getBytes());
        channel.write(buf);
        return absolutePath;
    }
}

