/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.netbeans.nbpackage.Configuration;
import org.apache.netbeans.nbpackage.NBPackage;
import org.apache.netbeans.nbpackage.Option;
import org.apache.netbeans.nbpackage.Packager;
import org.apache.netbeans.nbpackage.StringUtils;

public final class ExecutionContext {
    private static final String TOKEN_IMAGE_DIR = "IMAGE";
    private final Packager packager;
    private final Path input;
    private final Path destination;
    private final Configuration configuration;
    private final boolean imageOnly;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private Path imagePath;

    ExecutionContext(Packager packager, Path input, Configuration config, Path destination, boolean imageOnly) {
        this.packager = packager;
        this.configuration = config;
        this.input = input;
        this.imagePath = null;
        this.destination = destination;
        this.imageOnly = imageOnly;
    }

    ExecutionContext(Packager packager, Path inputImage, Configuration configuration, Path destination) {
        this.packager = packager;
        this.input = null;
        this.imagePath = inputImage;
        this.configuration = configuration;
        this.destination = destination;
        this.imageOnly = false;
    }

    public Path input() {
        return this.input;
    }

    public Path image() {
        return this.imagePath;
    }

    public Path destination() {
        return this.destination;
    }

    public int exec(String ... command) throws IOException, InterruptedException {
        return this.exec(List.of(command));
    }

    public int exec(List<String> command) throws IOException, InterruptedException {
        return this.exec(new ProcessBuilder(command));
    }

    public int exec(ProcessBuilder processBuilder) throws IOException, InterruptedException {
        boolean showOutput = this.isVerbose();
        if (showOutput) {
            processBuilder.redirectErrorStream(true);
            processBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        } else {
            processBuilder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
            processBuilder.redirectError(ProcessBuilder.Redirect.DISCARD);
        }
        Process p = processBuilder.start();
        if (showOutput) {
            Consumer<String> info = this.infoHandler();
            Consumer<String> warning = this.warningHandler();
            this.executor.submit(() -> {
                try (BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    in.lines().forEachOrdered(info);
                }
                catch (IOException ex) {
                    warning.accept(ex.getClass().getSimpleName());
                }
            });
        }
        return p.waitFor();
    }

    public String execAndGetOutput(String ... command) throws IOException, InterruptedException {
        return this.execAndGetOutput(List.of(command));
    }

    public String execAndGetOutput(List<String> command) throws IOException, InterruptedException {
        return this.execAndGetOutput(new ProcessBuilder(command));
    }

    public String execAndGetOutput(ProcessBuilder processBuilder) throws IOException, InterruptedException {
        boolean showOutput = this.isVerbose();
        Path tmp = Files.createTempFile("nbpackage", ".tmp", new FileAttribute[0]);
        processBuilder.redirectOutput(tmp.toFile());
        processBuilder.redirectError(showOutput ? ProcessBuilder.Redirect.PIPE : ProcessBuilder.Redirect.DISCARD);
        Process p = processBuilder.start();
        if (showOutput) {
            Consumer<String> info = this.configuration.infoHandler();
            Consumer<String> warning = this.configuration.warningHandler();
            this.executor.submit(() -> {
                try (BufferedReader in = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
                    in.lines().forEachOrdered(info);
                }
                catch (IOException ex) {
                    warning.accept(ex.getClass().getSimpleName());
                }
            });
        }
        p.waitFor();
        String out = Files.readString(tmp);
        Files.delete(tmp);
        return out;
    }

    public List<String> splitCommandLine(String command) {
        return ExecutionContext.parseParameters(command);
    }

    public <T> Optional<T> getValue(Option<T> option) {
        String raw = this.configuration.getValue(option);
        if (!raw.isBlank()) {
            raw = this.replaceTokens(raw);
            try {
                return Optional.of(option.parse(raw));
            }
            catch (Exception ex) {
                String msg = MessageFormat.format(NBPackage.MESSAGES.getString("message.invalidoptionvalue"), option.key(), raw);
                throw new IllegalArgumentException(msg, ex);
            }
        }
        return Optional.empty();
    }

    public String getRawValue(Option<?> option) {
        return this.configuration.getValue(option);
    }

    public boolean isDefaultValue(Option<?> option) {
        return option.defaultValue().equals(this.getRawValue(option));
    }

    public boolean isImageOnly() {
        return this.imageOnly;
    }

    public boolean isVerbose() {
        return this.configuration.isVerbose();
    }

    public String replaceTokens(String input) {
        return StringUtils.replaceTokens(input, this::tokenReplacementFor);
    }

    public String tokenReplacementFor(String token) {
        if (TOKEN_IMAGE_DIR.equals(token)) {
            if (this.imagePath != null) {
                return this.imagePath.toString();
            }
        } else {
            Option opt = NBPackage.options().filter(o -> o.key().equals(token)).findFirst().orElse(null);
            if (opt != null) {
                return this.getValue(opt).map(Object::toString).orElse(opt.defaultValue());
            }
        }
        return null;
    }

    public Consumer<String> infoHandler() {
        return this.configuration.infoHandler();
    }

    public Consumer<String> warningHandler() {
        return this.configuration.warningHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Path execute() throws Exception {
        try {
            Path result;
            this.infoHandler().accept(MessageFormat.format(NBPackage.MESSAGES.getString("message.creatingtask"), this.packager.name()));
            Packager.Task task = this.packager.createTask(this);
            this.validateConfiguration();
            if (this.input != null) {
                this.infoHandler().accept(NBPackage.MESSAGES.getString("message.validatingimage"));
                task.validateCreateImage();
            }
            if (!this.imageOnly) {
                this.infoHandler().accept(NBPackage.MESSAGES.getString("message.validatingpackage"));
                task.validateCreatePackage();
            }
            if (this.input != null) {
                this.infoHandler().accept(MessageFormat.format(NBPackage.MESSAGES.getString("message.creatingimage"), this.input));
                this.imagePath = task.createImage(this.input);
            }
            if (this.imageOnly) {
                result = this.imagePath;
            } else {
                this.infoHandler().accept(MessageFormat.format(NBPackage.MESSAGES.getString("message.creatingpackage"), this.imagePath));
                result = task.createPackage(this.imagePath);
            }
            this.infoHandler().accept(MessageFormat.format(NBPackage.MESSAGES.getString("message.outputcreated"), result));
            Path path = result;
            return path;
        }
        finally {
            this.executor.shutdown();
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    private void validateConfiguration() {
        Map options = Stream.concat(NBPackage.globalOptions(), this.packager.options()).collect(Collectors.toMap(Option::key, Function.identity()));
        this.configuration.properties().keySet().stream().sorted().forEach(key -> {
            Option option = (Option)options.get(key);
            if (option == null) {
                this.warningHandler().accept(MessageFormat.format(NBPackage.MESSAGES.getString("message.unknownoption"), key, this.packager.name()));
            } else if (option.status() == Option.Status.DEPRECATED) {
                this.warningHandler().accept(MessageFormat.format(NBPackage.MESSAGES.getString("message.deprecatedoption"), key, this.packager.name()));
            }
        });
    }

    private static List<String> parseParameters(String s) {
        boolean NULL = false;
        boolean IN_PARAM = true;
        int IN_DOUBLE_QUOTE = 2;
        int IN_SINGLE_QUOTE = 3;
        ArrayList<String> params = new ArrayList<String>(5);
        int state = 0;
        StringBuilder buff = new StringBuilder(20);
        int slength = s.length();
        block18: for (int i = 0; i < slength; ++i) {
            char c = s.charAt(i);
            switch (state) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            state = 3;
                            continue block18;
                        }
                        case '\"': {
                            state = 2;
                            continue block18;
                        }
                    }
                    if (Character.isWhitespace(c)) continue block18;
                    buff.append(c);
                    state = 1;
                    continue block18;
                }
                case 3: {
                    if (c != '\'') {
                        buff.append(c);
                        continue block18;
                    }
                    state = 1;
                    continue block18;
                }
                case 2: {
                    switch (c) {
                        case '\\': {
                            char peek;
                            char c2 = peek = i < slength - 1 ? s.charAt(i + 1) : (char)'\u0000';
                            if (peek == '\"' || peek == '\\') {
                                buff.append(peek);
                                ++i;
                                continue block18;
                            }
                            buff.append(c);
                            continue block18;
                        }
                        case '\"': {
                            state = 1;
                            continue block18;
                        }
                    }
                    buff.append(c);
                    continue block18;
                }
                case 1: {
                    switch (c) {
                        case '\'': {
                            state = 3;
                            continue block18;
                        }
                        case '\"': {
                            state = 2;
                            continue block18;
                        }
                    }
                    if (Character.isWhitespace(c)) {
                        params.add(buff.toString());
                        buff.setLength(0);
                        state = 0;
                        continue block18;
                    }
                    buff.append(c);
                }
            }
        }
        if (buff.length() > 0) {
            params.add(buff.toString());
        }
        return List.copyOf(params);
    }
}

