/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.lib.terminalemulator.support;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/**
 *
 * @author ivan
 */
class Catalog {
    private static final Package pkg = Catalog.class.getPackage();
    private static final String baseName =
	pkg.getName().replace(".", "/") + "/Bundle";	// NOI18N
    private static final ResourceBundle bundle =
        ResourceBundle.getBundle(baseName);

    public static String get(String key) {
        return bundle.getString(key);
    }

    public static int mnemonic(String key) {
        String value = bundle.getString(key);
        assert value.length() == 1 : "Mnemonic for " + key + "must be a single character, not " + value;
        return value.charAt(0);
    }

    public static String format(String formatKey, Object... args) {
        return MessageFormat.format(get(formatKey), args);
    }
}
