/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.java.editor.base.semantic;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.openide.filesystems.FileUtil;

/**
 *
 * @author Jan Lahoda
 */
public class ShowGoldenFilesPanel extends javax.swing.JPanel {

    private Component c;
    private File goldenFile;
    private File testFile;
    
    /** Creates new form ShowGoldenFilesPanel */
    public ShowGoldenFilesPanel(Component c) {
        this.c = c;
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jEditorPane1 = new javax.swing.JEditorPane();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        goldenField = new javax.swing.JTextField();
        testField = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();

        jEditorPane1.addCaretListener(new javax.swing.event.CaretListener() {
            public void caretUpdate(javax.swing.event.CaretEvent evt) {
                jEditorPane1CaretUpdate(evt);
            }
        });
        jScrollPane1.setViewportView(jEditorPane1);

        jLabel1.setText("Golden:");

        jLabel2.setText("Test:");

        goldenField.setText("jTextField1");

        testField.setText("jTextField2");

        jButton1.setText("Accept");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButton2.setText("Refuse");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(jLabel2))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(testField, javax.swing.GroupLayout.DEFAULT_SIZE, 317, Short.MAX_VALUE)
                            .addComponent(goldenField, javax.swing.GroupLayout.DEFAULT_SIZE, 317, Short.MAX_VALUE)))
                    .addComponent(jScrollPane1)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButton1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton2)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 195, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(goldenField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(testField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton2)
                    .addComponent(jButton1))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
// TODO add your handling code here:
        InputStream source = null;
        OutputStream target = null;
                
        try {
            source = new FileInputStream(testFile);
            target = new FileOutputStream(goldenFile);
            
            FileUtil.copy(source, target);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (source != null) {
                try {
                    source.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (target != null) {
                try {
                    target.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        c.setVisible(false);
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jEditorPane1CaretUpdate(javax.swing.event.CaretEvent evt) {//GEN-FIRST:event_jEditorPane1CaretUpdate
        int pos = jEditorPane1.getCaretPosition();
        HighlightImpl goldenHighlight = null;
        HighlightImpl testHighlight   = null;
        
        for (HighlightImpl h : golden) {
            if (h.getStart() <= pos && pos <= h.getEnd()) {
                goldenHighlight = h;
                break;
            }
        }
        
        for (HighlightImpl h : test) {
            if (h.getStart() <= pos && pos <= h.getEnd()) {
                testHighlight = h;
                break;
            }
        }
        
        if (goldenHighlight != null)
            goldenField.setText(goldenHighlight.getHighlightTestData());
        else
            goldenField.setText("<none>");
        if (testHighlight != null )
            testField.setText(testHighlight.getHighlightTestData());
        else
            testField.setText("<none>");
    }//GEN-LAST:event_jEditorPane1CaretUpdate
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JTextField goldenField;
    public javax.swing.JButton jButton1;
    public javax.swing.JButton jButton2;
    public javax.swing.JEditorPane jEditorPane1;
    public javax.swing.JLabel jLabel1;
    public javax.swing.JLabel jLabel2;
    public javax.swing.JScrollPane jScrollPane1;
    public javax.swing.JTextField testField;
    // End of variables declaration//GEN-END:variables
    
    private List<HighlightImpl> golden;
    private List<HighlightImpl> test;
    
    public void setDocument(StyledDocument doc, List<HighlightImpl> golden, List<HighlightImpl> test, File goldenFile, File testFile) {
        this.golden = golden;
        this.test = test;
        this.goldenFile = goldenFile;
        this.testFile = testFile;
        List<HighlightImpl> missing = new ArrayList<HighlightImpl>();
        List<HighlightImpl> added   = new ArrayList<HighlightImpl>();
        
        Map<String, HighlightImpl> name2Golden = new HashMap<String, HighlightImpl>();
        Map<String, HighlightImpl> name2Test   = new HashMap<String, HighlightImpl>();
        
        for (HighlightImpl g : golden) {
            name2Golden.put(g.getHighlightTestData(), g);
        }
        
        for (HighlightImpl t : test) {
            name2Test.put(t.getHighlightTestData(), t);
        }
        
        Set<String> missingNames = new HashSet<String>(name2Golden.keySet());
        
        missingNames.removeAll(name2Test.keySet());
        
        for (String m : missingNames) {
            missing.add(name2Golden.get(m));
        }
        
        Set<String> addedNames = new HashSet<String>(name2Test.keySet());
        
        addedNames.removeAll(name2Golden.keySet());
        
        for (String a : addedNames) {
            added.add(name2Test.get(a));
        }
        
        List<HighlightImpl> modified = new ArrayList<HighlightImpl>();
        
        modified.addAll(missing);
        modified.addAll(added);
        
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet as = sc.getEmptySet();
        
        as = sc.addAttribute(as, StyleConstants.Foreground, Color.RED);
        as = sc.addAttribute(as, StyleConstants.Bold, Boolean.TRUE);
        
        for (HighlightImpl h : modified) {
            doc.setCharacterAttributes(h.getStart(), h.getEnd() - h.getStart(), as, false);
        }
        
        jEditorPane1.setContentType("text/html");
        jEditorPane1.setDocument(doc);
    }
    
}
