/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.util;

import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.minifi.commons.schema.ProvenanceReportingSchema;
import org.apache.nifi.minifi.commons.schema.SecurityPropertiesSchema;
import org.apache.nifi.minifi.commons.schema.common.BootstrapPropertyKeys;

public class BootstrapTransformer {
    public static Optional<SecurityPropertiesSchema> buildSecurityPropertiesFromBootstrap(Properties bootstrapProperties) {
        Optional<SecurityPropertiesSchema> securityPropsOptional = Optional.empty();
        HashMap securityProperties = new HashMap();
        if (bootstrapProperties != null) {
            BootstrapPropertyKeys.BOOTSTRAP_SECURITY_PROPERTY_KEYS.stream().filter(key -> StringUtils.isNotBlank((CharSequence)bootstrapProperties.getProperty((String)key))).forEach(key -> securityProperties.put((String)BootstrapPropertyKeys.BOOTSTRAP_KEYS_TO_YML_KEYS.get(key), bootstrapProperties.getProperty((String)key)));
            if (!securityProperties.isEmpty()) {
                HashMap sensitiveProperties = new HashMap();
                BootstrapPropertyKeys.BOOTSTRAP_SENSITIVE_PROPERTY_KEYS.stream().filter(key -> StringUtils.isNotBlank((CharSequence)bootstrapProperties.getProperty((String)key))).forEach(key -> sensitiveProperties.put(BootstrapPropertyKeys.BOOTSTRAP_KEYS_TO_YML_KEYS.get(key), bootstrapProperties.getProperty((String)key)));
                if (!sensitiveProperties.isEmpty()) {
                    securityProperties.put("Sensitive Props", sensitiveProperties);
                }
                SecurityPropertiesSchema securityPropertiesSchema = new SecurityPropertiesSchema(securityProperties);
                securityPropsOptional = Optional.of(securityPropertiesSchema);
            }
        }
        return securityPropsOptional;
    }

    public static Optional<ProvenanceReportingSchema> buildProvenanceReportingPropertiesFromBootstrap(Properties bootstrapProperties) {
        Optional<ProvenanceReportingSchema> provenanceReportingPropsOptional = Optional.empty();
        HashMap provenanceReportingProperties = new HashMap();
        if (bootstrapProperties != null) {
            BootstrapPropertyKeys.BOOTSTRAP_PROVENANCE_REPORTING_KEYS.stream().filter(key -> StringUtils.isNotBlank((CharSequence)bootstrapProperties.getProperty((String)key))).forEach(key -> provenanceReportingProperties.put(BootstrapPropertyKeys.BOOTSTRAP_KEYS_TO_YML_KEYS.get(key), bootstrapProperties.getProperty((String)key)));
            if (!provenanceReportingProperties.isEmpty()) {
                ProvenanceReportingSchema provenanceReportingSchema = new ProvenanceReportingSchema(provenanceReportingProperties);
                provenanceReportingPropsOptional = Optional.of(provenanceReportingSchema);
            }
        }
        return provenanceReportingPropsOptional;
    }

    public static boolean processorSSLOverride(Properties bootstrapProperties) {
        boolean shouldOverride = false;
        if (bootstrapProperties != null) {
            shouldOverride = Boolean.parseBoolean(bootstrapProperties.getProperty("nifi.minifi.flow.use.parent.ssl"));
        }
        return shouldOverride;
    }
}

