/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.CompositeUserAndGroups;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserAndGroups;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.authorization.UserGroupProviderLookup;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeUserGroupProvider
implements UserGroupProvider {
    private static final Logger logger = LoggerFactory.getLogger(CompositeUserGroupProvider.class);
    static final String PROP_USER_GROUP_PROVIDER_PREFIX = "User Group Provider ";
    static final Pattern USER_GROUP_PROVIDER_PATTERN = Pattern.compile("User Group Provider \\S+");
    private final boolean allowEmptyProviderList;
    private UserGroupProviderLookup userGroupProviderLookup;
    private List<UserGroupProvider> userGroupProviders = new ArrayList<UserGroupProvider>();

    public CompositeUserGroupProvider() {
        this(false);
    }

    public CompositeUserGroupProvider(boolean allowEmptyProviderList) {
        this.allowEmptyProviderList = allowEmptyProviderList;
    }

    public void initialize(UserGroupProviderInitializationContext initializationContext) throws AuthorizerCreationException {
        this.userGroupProviderLookup = initializationContext.getUserGroupProviderLookup();
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
        for (Map.Entry entry : configurationContext.getProperties().entrySet()) {
            Matcher matcher = USER_GROUP_PROVIDER_PATTERN.matcher((CharSequence)entry.getKey());
            if (!matcher.matches() || StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            String userGroupProviderKey = (String)entry.getValue();
            UserGroupProvider userGroupProvider = this.userGroupProviderLookup.getUserGroupProvider(userGroupProviderKey);
            if (userGroupProvider == null) {
                throw new AuthorizerCreationException(String.format("Unable to locate the configured User Group Provider: %s", userGroupProviderKey));
            }
            if (this.userGroupProviders.contains(userGroupProvider)) {
                throw new AuthorizerCreationException(String.format("Duplicate provider in Composite User Group Provider configuration: %s", userGroupProviderKey));
            }
            this.userGroupProviders.add(userGroupProvider);
        }
        if (!this.allowEmptyProviderList && this.userGroupProviders.isEmpty()) {
            throw new AuthorizerCreationException("At least one User Group Provider must be configured.");
        }
    }

    public Set<User> getUsers() throws AuthorizationAccessException {
        HashSet<User> users = new HashSet<User>();
        for (UserGroupProvider userGroupProvider : this.userGroupProviders) {
            users.addAll(userGroupProvider.getUsers());
        }
        return users;
    }

    public User getUser(String identifier) throws AuthorizationAccessException {
        UserGroupProvider userGroupProvider;
        User user = null;
        Iterator<UserGroupProvider> iterator = this.userGroupProviders.iterator();
        while (iterator.hasNext() && (user = (userGroupProvider = iterator.next()).getUser(identifier)) == null) {
        }
        return user;
    }

    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
        UserGroupProvider userGroupProvider;
        User user = null;
        Iterator<UserGroupProvider> iterator = this.userGroupProviders.iterator();
        while (iterator.hasNext() && (user = (userGroupProvider = iterator.next()).getUserByIdentity(identity)) == null) {
        }
        return user;
    }

    public Set<Group> getGroups() throws AuthorizationAccessException {
        HashSet<Group> groups = new HashSet<Group>();
        for (UserGroupProvider userGroupProvider : this.userGroupProviders) {
            groups.addAll(userGroupProvider.getGroups());
        }
        return groups;
    }

    public Group getGroup(String identifier) throws AuthorizationAccessException {
        UserGroupProvider userGroupProvider;
        Group group = null;
        Iterator<UserGroupProvider> iterator = this.userGroupProviders.iterator();
        while (iterator.hasNext() && (group = (userGroupProvider = iterator.next()).getGroup(identifier)) == null) {
        }
        return group;
    }

    public Group getGroupByName(String name) throws AuthorizationAccessException {
        UserGroupProvider userGroupProvider;
        Group group = null;
        Iterator<UserGroupProvider> iterator = this.userGroupProviders.iterator();
        while (iterator.hasNext() && (group = (userGroupProvider = iterator.next()).getGroupByName(name)) == null) {
        }
        return group;
    }

    public UserAndGroups getUserAndGroups(String identity) throws AuthorizationAccessException {
        CompositeUserAndGroups compositeUserAndGroups = new CompositeUserAndGroups();
        String providerClassForUser = "";
        for (UserGroupProvider userGroupProvider : this.userGroupProviders) {
            UserAndGroups userAndGroups = userGroupProvider.getUserAndGroups(identity);
            if (userAndGroups.getUser() != null) {
                if (compositeUserAndGroups.getUser() == null) {
                    compositeUserAndGroups.setUser(userAndGroups.getUser());
                    providerClassForUser = userGroupProvider.getClass().getName();
                } else {
                    logger.warn("Multiple UserGroupProviders are claiming to provide identity [{}] user '{}': [{} and {}] ", new Object[]{identity, userAndGroups.getUser(), providerClassForUser, userGroupProvider.getClass().getName()});
                    throw new IllegalStateException("Multiple UserGroupProviders are claiming to provide user " + identity);
                }
            }
            if (userAndGroups.getGroups() == null) continue;
            compositeUserAndGroups.addAllGroups(userAndGroups.getGroups());
        }
        if (compositeUserAndGroups.getUser() == null) {
            logger.debug("No user found for identity {}", (Object)identity);
            return UserAndGroups.EMPTY;
        }
        String userIdentifier = compositeUserAndGroups.getUser().getIdentifier();
        for (UserGroupProvider userGroupProvider : this.userGroupProviders) {
            for (Group group : userGroupProvider.getGroups()) {
                if (group.getUsers() == null || !group.getUsers().contains(userIdentifier)) continue;
                compositeUserAndGroups.addGroup(group);
            }
        }
        return compositeUserAndGroups;
    }

    public void preDestruction() throws AuthorizerDestructionException {
        Exception error = null;
        for (UserGroupProvider userGroupProvider : this.userGroupProviders) {
            try {
                userGroupProvider.preDestruction();
            }
            catch (Exception e) {
                error = e;
                logger.error("Error pre-destructing: " + e);
            }
        }
        if (error != null) {
            throw new AuthorizerDestructionException(error);
        }
    }
}

