/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.BindingUtils;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public class ShortBinding
extends ComparableBinding {
    public static final ShortBinding BINDING = new ShortBinding();

    private ShortBinding() {
    }

    @Override
    public Short readObject(@NotNull ByteArrayInputStream stream) {
        return BindingUtils.readShort(stream);
    }

    @Override
    public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable object) {
        output.writeUnsignedShort((int)((Short)object ^ 0x8000));
    }

    public static short entryToShort(@NotNull ByteIterable entry) {
        return (Short)BINDING.entryToObject(entry);
    }

    public static ArrayByteIterable shortToEntry(short object) {
        return BINDING.objectToEntry(Short.valueOf(object));
    }
}

