/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.impl;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CopyingInputStream
extends FilterInputStream {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final int maxBytesToCopy;
    private final InputStream in;

    public CopyingInputStream(InputStream in, int maxBytesToCopy) {
        super(in);
        this.maxBytesToCopy = maxBytesToCopy;
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int delegateRead = this.in.read();
        if (delegateRead != -1 && this.getNumberOfBytesCopied() < this.maxBytesToCopy) {
            this.baos.write(delegateRead);
        }
        return delegateRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int delegateRead = this.in.read(b);
        if (delegateRead >= 0) {
            this.baos.write(b, 0, Math.min(delegateRead, this.maxBytesToCopy - this.getNumberOfBytesCopied()));
        }
        return delegateRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int delegateRead = this.in.read(b, off, len);
        if (delegateRead >= 0) {
            this.baos.write(b, off, Math.min(delegateRead, this.maxBytesToCopy - this.getNumberOfBytesCopied()));
        }
        return delegateRead;
    }

    public byte[] getBytesRead() {
        return this.baos.toByteArray();
    }

    public void writeBytes(OutputStream out) throws IOException {
        this.baos.writeTo(out);
    }

    public int getNumberOfBytesCopied() {
        return this.baos.size();
    }
}

