/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.iterate.BinarySearchIdFilter;
import jetbrains.exodus.entitystore.iterate.BloomIdFilter;
import jetbrains.exodus.entitystore.iterate.IdFilter;
import jetbrains.exodus.entitystore.iterate.LinearSearchIdFilter;
import jetbrains.exodus.entitystore.iterate.SingleIdFilter;
import jetbrains.exodus.entitystore.iterate.TrivialNegativeIdFilter;
import org.jetbrains.annotations.NotNull;

abstract class InitialIdFilter
implements IdFilter {
    InitialIdFilter() {
    }

    @Override
    public boolean hasId(int id) {
        int[] ids = this.getIds();
        int idCount = ids.length;
        if (idCount == 0) {
            this.setFinalIdFilter(TrivialNegativeIdFilter.INSTANCE);
            return false;
        }
        if (idCount == 1) {
            int singleId = ids[0];
            this.setFinalIdFilter(new SingleIdFilter(singleId));
            return singleId == id;
        }
        BloomIdFilter finalFilter = idCount < 4 ? new LinearSearchIdFilter(ids) : new BinarySearchIdFilter(ids);
        this.setFinalIdFilter(finalFilter);
        return finalFilter.hasId(id);
    }

    abstract int[] getIds();

    abstract void setFinalIdFilter(@NotNull IdFilter var1);
}

