/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.documentation.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.nifi.annotation.behavior.DynamicRelationship;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.documentation.html.HtmlDocumentationWriter;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;

public class HtmlProcessorDocumentationWriter
extends HtmlDocumentationWriter {
    public HtmlProcessorDocumentationWriter(ExtensionManager extensionManager) {
        super(extensionManager);
    }

    @Override
    protected void writeAdditionalBodyInfo(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        Processor processor = (Processor)configurableComponent;
        this.writeRelationships(processor, xmlStreamWriter);
        this.writeDynamicRelationships(processor, xmlStreamWriter);
        this.writeAttributeInfo(processor, xmlStreamWriter);
    }

    private void writeAttributeInfo(Processor processor, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        this.handleReadsAttributes(xmlStreamWriter, processor);
        this.handleWritesAttributes(xmlStreamWriter, processor);
    }

    private String defaultIfBlank(String test, String defaultValue) {
        if (test == null || test.trim().isEmpty()) {
            return defaultValue;
        }
        return test;
    }

    private void handleReadsAttributes(XMLStreamWriter xmlStreamWriter, Processor processor) throws XMLStreamException {
        List<ReadsAttribute> attributesRead = this.getReadsAttributes(processor);
        HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Reads Attributes: ");
        if (attributesRead.size() > 0) {
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "reads-attributes");
            xmlStreamWriter.writeStartElement("tr");
            HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Name");
            HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (ReadsAttribute attribute : attributesRead) {
                xmlStreamWriter.writeStartElement("tr");
                HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", this.defaultIfBlank(attribute.attribute(), "Not Specified"));
                HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", this.defaultIfBlank(attribute.description(), "Not Specified"));
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        } else {
            xmlStreamWriter.writeCharacters("None specified.");
        }
    }

    private void handleWritesAttributes(XMLStreamWriter xmlStreamWriter, Processor processor) throws XMLStreamException {
        List<WritesAttribute> attributesRead = this.getWritesAttributes(processor);
        HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Writes Attributes: ");
        if (attributesRead.size() > 0) {
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "writes-attributes");
            xmlStreamWriter.writeStartElement("tr");
            HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Name");
            HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (WritesAttribute attribute : attributesRead) {
                xmlStreamWriter.writeStartElement("tr");
                HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", this.defaultIfBlank(attribute.attribute(), "Not Specified"));
                HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", this.defaultIfBlank(attribute.description(), "Not Specified"));
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        } else {
            xmlStreamWriter.writeCharacters("None specified.");
        }
    }

    private List<ReadsAttribute> getReadsAttributes(Processor processor) {
        ReadsAttribute readsAttribute;
        ArrayList<ReadsAttribute> attributes = new ArrayList<ReadsAttribute>();
        ReadsAttributes readsAttributes = processor.getClass().getAnnotation(ReadsAttributes.class);
        if (readsAttributes != null) {
            attributes.addAll(Arrays.asList(readsAttributes.value()));
        }
        if ((readsAttribute = processor.getClass().getAnnotation(ReadsAttribute.class)) != null) {
            attributes.add(readsAttribute);
        }
        return attributes;
    }

    private List<WritesAttribute> getWritesAttributes(Processor processor) {
        WritesAttribute writeAttribute;
        ArrayList<WritesAttribute> attributes = new ArrayList<WritesAttribute>();
        WritesAttributes writesAttributes = processor.getClass().getAnnotation(WritesAttributes.class);
        if (writesAttributes != null) {
            attributes.addAll(Arrays.asList(writesAttributes.value()));
        }
        if ((writeAttribute = processor.getClass().getAnnotation(WritesAttribute.class)) != null) {
            attributes.add(writeAttribute);
        }
        return attributes;
    }

    private void writeRelationships(Processor processor, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Relationships: ");
        if (processor.getRelationships().size() > 0) {
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "relationships");
            xmlStreamWriter.writeStartElement("tr");
            HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Name");
            HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (Relationship relationship : processor.getRelationships()) {
                xmlStreamWriter.writeStartElement("tr");
                HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", relationship.getName());
                HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", relationship.getDescription());
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        } else {
            xmlStreamWriter.writeCharacters("This processor has no relationships.");
        }
    }

    private void writeDynamicRelationships(Processor processor, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        List<DynamicRelationship> dynamicRelationships = this.getDynamicRelationships(processor);
        if (dynamicRelationships.size() > 0) {
            HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Dynamic Relationships: ");
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("A Dynamic Relationship may be created based on how the user configures the Processor.");
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "dynamic-relationships");
            xmlStreamWriter.writeStartElement("tr");
            HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Name");
            HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (DynamicRelationship dynamicRelationship : dynamicRelationships) {
                xmlStreamWriter.writeStartElement("tr");
                HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", dynamicRelationship.name());
                HtmlProcessorDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", dynamicRelationship.description());
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
        }
    }

    private List<DynamicRelationship> getDynamicRelationships(Processor processor) {
        ArrayList<DynamicRelationship> results = new ArrayList<DynamicRelationship>();
        DynamicRelationship dynamicRelationships = processor.getClass().getAnnotation(DynamicRelationship.class);
        if (dynamicRelationships != null) {
            results.add(dynamicRelationships);
        }
        return results;
    }
}

