/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.FlowRegistryClientConfigurationContext;
import org.apache.nifi.registry.flow.FlowRegistryClientInitializationContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;

public class GhostFlowRegistryClient
implements FlowRegistryClient {
    public static final String ERROR_MESSAGE = "Unable to instantiate FlowRegistryClient class";
    private final String id;
    private final String canonicalClassName;

    public GhostFlowRegistryClient(String id, String canonicalClassName) {
        this.id = id;
        this.canonicalClassName = canonicalClassName;
    }

    public void initialize(FlowRegistryClientInitializationContext context) {
    }

    public boolean isStorageLocationApplicable(FlowRegistryClientConfigurationContext context, String location) {
        return false;
    }

    public Collection<ValidationResult> validate(ValidationContext context) {
        return Collections.singleton(new ValidationResult.Builder().input("Any Property").subject("Missing Registry Client").valid(false).explanation("Registry Client is of type " + this.canonicalClassName + ", but this is not a valid Registry Client type").build());
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return new PropertyDescriptor.Builder().name(propertyName).description(propertyName).required(true).sensitive(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
    }

    public List<PropertyDescriptor> getPropertyDescriptors() {
        return Collections.emptyList();
    }

    public String getIdentifier() {
        return this.id;
    }

    public Set<FlowRegistryBucket> getBuckets(FlowRegistryClientConfigurationContext context) throws FlowRegistryException {
        throw new FlowRegistryException(ERROR_MESSAGE);
    }

    public FlowRegistryBucket getBucket(FlowRegistryClientConfigurationContext context, String bucketId) throws FlowRegistryException {
        throw new FlowRegistryException(ERROR_MESSAGE);
    }

    public RegisteredFlow registerFlow(FlowRegistryClientConfigurationContext context, RegisteredFlow flow) throws FlowRegistryException {
        throw new FlowRegistryException(ERROR_MESSAGE);
    }

    public RegisteredFlow deregisterFlow(FlowRegistryClientConfigurationContext context, String bucketId, String flowId) throws FlowRegistryException {
        throw new FlowRegistryException(ERROR_MESSAGE);
    }

    public RegisteredFlow getFlow(FlowRegistryClientConfigurationContext context, String bucketId, String flowId) throws FlowRegistryException {
        throw new FlowRegistryException(ERROR_MESSAGE);
    }

    public Set<RegisteredFlow> getFlows(FlowRegistryClientConfigurationContext context, String bucketId) throws FlowRegistryException {
        throw new FlowRegistryException(ERROR_MESSAGE);
    }

    public RegisteredFlowSnapshot getFlowContents(FlowRegistryClientConfigurationContext context, String bucketId, String flowId, int version) throws FlowRegistryException {
        throw new FlowRegistryException(ERROR_MESSAGE);
    }

    public RegisteredFlowSnapshot registerFlowSnapshot(FlowRegistryClientConfigurationContext context, RegisteredFlowSnapshot flowSnapshot) throws FlowRegistryException {
        throw new FlowRegistryException(ERROR_MESSAGE);
    }

    public Set<RegisteredFlowSnapshotMetadata> getFlowVersions(FlowRegistryClientConfigurationContext context, String bucketId, String flowId) throws FlowRegistryException {
        throw new FlowRegistryException(ERROR_MESSAGE);
    }

    public int getLatestVersion(FlowRegistryClientConfigurationContext context, String bucketId, String flowId) throws FlowRegistryException {
        throw new FlowRegistryException(ERROR_MESSAGE);
    }
}

