/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.metrics.HealthMetricsImpl;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;

public class HealthCheckProcessor
implements HttpRequestProcessor {
    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpChunkedResponseSocket r = context.getChunkedResponseSocket();
        HealthMetricsImpl metrics = context.getMetrics().health();
        long unhandledErrors = metrics.unhandledErrorsCount();
        if (unhandledErrors > 0L) {
            r.status(500, "text/plain");
            r.sendHeader();
            r.put("Status: Unhealthy\nUnhandled errors: ");
            r.put(unhandledErrors);
            r.sendChunk(true);
            return;
        }
        r.status(200, "text/plain");
        r.sendHeader();
        r.put("Status: Healthy");
        r.sendChunk(true);
    }
}

