/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.udp;

import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.line.udp.LineUdpLexer;
import io.questdb.cutlass.line.udp.LineUdpParserImpl;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.mp.SynchronizedJob;
import io.questdb.mp.WorkerPool;
import io.questdb.network.NetworkError;
import io.questdb.network.NetworkFacade;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractLineProtoUdpReceiver
extends SynchronizedJob
implements Closeable {
    private static final Log LOG = LogFactory.getLog(AbstractLineProtoUdpReceiver.class);
    protected final int commitMode;
    protected final LineUdpLexer lexer;
    protected final NetworkFacade nf;
    protected final LineUdpParserImpl parser;
    private final LineUdpReceiverConfiguration configuration;
    private final SOCountDownLatch halted = new SOCountDownLatch(1);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final SOCountDownLatch started = new SOCountDownLatch(1);
    protected int commitRate;
    protected int fd;
    protected long totalCount = 0L;

    public AbstractLineProtoUdpReceiver(LineUdpReceiverConfiguration configuration, CairoEngine engine, WorkerPool workerPool) {
        this.configuration = configuration;
        this.commitMode = configuration.getCommitMode();
        this.nf = configuration.getNetworkFacade();
        this.fd = this.nf.socketUdp();
        if (this.fd < 0) {
            int errno = this.nf.errno();
            LOG.error().$("cannot open UDP socket [errno=").$(errno).$(']').$();
            throw NetworkError.instance(errno, "Cannot open UDP socket");
        }
        try {
            this.bind(configuration);
            this.commitRate = configuration.getCommitRate();
            if (configuration.getReceiveBufferSize() != -1 && this.nf.setRcvBuf(this.fd, configuration.getReceiveBufferSize()) != 0) {
                LOG.error().$("could not set receive buffer size [fd=").$(this.fd).$(", size=").$(configuration.getReceiveBufferSize()).$(", errno=").$(configuration.getNetworkFacade().errno()).I$();
            }
            this.lexer = new LineUdpLexer(configuration.getMsgBufferSize());
            this.parser = new LineUdpParserImpl(engine, configuration);
            this.lexer.withParser(this.parser);
            if (!configuration.ownThread()) {
                workerPool.assign(this);
                this.logStarted(configuration);
            }
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.fd > -1) {
            if (this.running.compareAndSet(true, false)) {
                this.started.await();
                this.halted.await();
            }
            if (this.nf.close(this.fd) != 0) {
                LOG.error().$("could not close [fd=").$(this.fd).$(", errno=").$(this.nf.errno()).$(']').$();
            } else {
                LOG.info().$("closed [fd=").$(this.fd).$(']').$();
            }
            if (this.parser != null) {
                this.parser.commitAll(this.commitMode);
                this.parser.close();
            }
            Misc.free(this.lexer);
            LOG.info().$("closed [fd=").$(this.fd).$(']').$();
            this.fd = -1;
        }
    }

    public void start() {
        if (this.configuration.ownThread() && this.running.compareAndSet(false, true)) {
            new Thread(() -> {
                this.started.countDown();
                if (this.configuration.ownThreadAffinity() != -1) {
                    Os.setCurrentThreadAffinity(this.configuration.ownThreadAffinity());
                }
                this.logStarted(this.configuration);
                while (this.running.get()) {
                    this.runSerially();
                }
                LOG.info().$("shutdown").$();
                Path.clearThreadLocals();
                this.halted.countDown();
            }).start();
        }
    }

    private void bind(LineUdpReceiverConfiguration configuration) {
        if (this.nf.bindUdp(this.fd, configuration.isUnicast() ? configuration.getBindIPv4Address() : 0, configuration.getPort())) {
            if (!configuration.isUnicast() && !this.nf.join(this.fd, configuration.getBindIPv4Address(), configuration.getGroupIPv4Address())) {
                throw NetworkError.instance(this.nf.errno()).put("cannot join group ").put("[fd=").put(this.fd).put(", bind=").ip(configuration.getBindIPv4Address()).put(", group=").ip(configuration.getGroupIPv4Address()).put(']');
            }
        } else {
            throw NetworkError.instance(this.nf.errno()).couldNotBindSocket("udp-line-server", configuration.getBindIPv4Address(), configuration.getPort());
        }
    }

    private void logStarted(LineUdpReceiverConfiguration configuration) {
        if (configuration.isUnicast()) {
            LOG.info().$("receiving unicast on ").$ip(configuration.getBindIPv4Address()).$(':').$(configuration.getPort()).$(" [fd=").$(this.fd).$(", commitRate=").$(this.commitRate).I$();
        } else {
            LOG.info().$("receiving multicast from ").$ip(configuration.getGroupIPv4Address()).$(':').$(configuration.getPort()).$(" via ").$ip(configuration.getBindIPv4Address()).$(" [fd=").$(this.fd).$(", commitRate=").$(this.commitRate).I$();
        }
    }
}

