/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryDescriptor;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.NegatingFunctionFactory;
import io.questdb.griffin.engine.functions.SwappingArgsFunctionFactory;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.IntHashSet;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.ObjList;

public class FunctionFactoryCache {
    static final IntHashSet invalidFunctionNameChars = new IntHashSet();
    static final CharSequenceHashSet invalidFunctionNames = new CharSequenceHashSet();
    private static final Log LOG = LogFactory.getLog(FunctionFactoryCache.class);
    private final LowerCaseCharSequenceHashSet cursorFunctionNames = new LowerCaseCharSequenceHashSet();
    private final LowerCaseCharSequenceObjHashMap<ObjList<FunctionFactoryDescriptor>> factories = new LowerCaseCharSequenceObjHashMap();
    private final LowerCaseCharSequenceHashSet groupByFunctionNames = new LowerCaseCharSequenceHashSet();
    private final LowerCaseCharSequenceHashSet runtimeConstantFunctionNames = new LowerCaseCharSequenceHashSet();

    public FunctionFactoryCache(CairoConfiguration configuration, Iterable<FunctionFactory> functionFactories) {
        boolean enableTestFactories = configuration.enableTestFactories();
        LOG.info().$("loading functions [test=").$(enableTestFactories).$(']').$();
        for (FunctionFactory factory : functionFactories) {
            if (factory.getClass().getName().contains("test") && !enableTestFactories) continue;
            try {
                FunctionFactoryDescriptor descriptor = new FunctionFactoryDescriptor(factory);
                String name = descriptor.getName();
                this.addFactoryToList(this.factories, descriptor);
                if (factory.isBoolean()) {
                    switch (name) {
                        case "=": {
                            this.addFactoryToList(this.factories, this.createNegatingFactory("!=", factory));
                            this.addFactoryToList(this.factories, this.createNegatingFactory("<>", factory));
                            if (descriptor.getArgTypeMask(0) == descriptor.getArgTypeMask(1)) break;
                            FunctionFactory swappingFactory = this.createSwappingFactory("=", factory);
                            this.addFactoryToList(this.factories, swappingFactory);
                            this.addFactoryToList(this.factories, this.createNegatingFactory("!=", swappingFactory));
                            this.addFactoryToList(this.factories, this.createNegatingFactory("<>", swappingFactory));
                            break;
                        }
                        case "<": {
                            this.addFactoryToList(this.factories, this.createNegatingFactory(">=", factory));
                            FunctionFactory greaterThan = this.createSwappingFactory(">", factory);
                            this.addFactoryToList(this.factories, greaterThan);
                            this.addFactoryToList(this.factories, this.createNegatingFactory("<=", greaterThan));
                        }
                    }
                    continue;
                }
                if (factory.isGroupBy()) {
                    this.groupByFunctionNames.add(name);
                    continue;
                }
                if (factory.isCursor()) {
                    this.cursorFunctionNames.add(name);
                    continue;
                }
                if (!factory.isRuntimeConstant()) continue;
                this.runtimeConstantFunctionNames.add(name);
            }
            catch (SqlException e) {
                LOG.error().$(e).$(" [signature=").$(factory.getSignature()).$(",class=").$(factory.getClass().getName()).$(']').$();
            }
        }
    }

    public LowerCaseCharSequenceObjHashMap<ObjList<FunctionFactoryDescriptor>> getFactories() {
        return this.factories;
    }

    public ObjList<FunctionFactoryDescriptor> getOverloadList(CharSequence token) {
        return this.factories.get(token);
    }

    public boolean isCursor(CharSequence name) {
        return name != null && this.cursorFunctionNames.contains(name);
    }

    public boolean isGroupBy(CharSequence name) {
        return name != null && this.groupByFunctionNames.contains(name);
    }

    public boolean isRuntimeConstant(CharSequence name) {
        return name != null && this.runtimeConstantFunctionNames.contains(name);
    }

    public boolean isValidNoArgFunction(ExpressionNode node) {
        ObjList<FunctionFactoryDescriptor> overload = this.getOverloadList(node.token);
        if (overload == null) {
            return false;
        }
        int n = overload.size();
        for (int i = 0; i < n; ++i) {
            FunctionFactoryDescriptor ffd = overload.getQuick(i);
            if (ffd.getSigArgCount() != 0) continue;
            return true;
        }
        return false;
    }

    private void addFactoryToList(LowerCaseCharSequenceObjHashMap<ObjList<FunctionFactoryDescriptor>> list, FunctionFactory factory) throws SqlException {
        this.addFactoryToList(list, new FunctionFactoryDescriptor(factory));
    }

    private void addFactoryToList(LowerCaseCharSequenceObjHashMap<ObjList<FunctionFactoryDescriptor>> list, FunctionFactoryDescriptor descriptor) {
        ObjList<FunctionFactoryDescriptor> overload;
        String name = descriptor.getName();
        int index = list.keyIndex(name);
        if (index < 0) {
            overload = list.valueAtQuick(index);
        } else {
            overload = new ObjList(4);
            list.putAt(index, name, overload);
        }
        overload.add(descriptor);
    }

    private FunctionFactory createNegatingFactory(String name, FunctionFactory factory) throws SqlException {
        return new NegatingFunctionFactory(name, factory);
    }

    private FunctionFactory createSwappingFactory(String name, FunctionFactory factory) throws SqlException {
        return new SwappingArgsFunctionFactory(name, factory);
    }

    int getFunctionCount() {
        return this.factories.size();
    }
}

