/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.analytic;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.AnalyticSPI;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.analytic.AnalyticContext;
import io.questdb.griffin.engine.analytic.AnalyticFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.orderby.RecordComparatorCompiler;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class RankFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "rank()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        AnalyticContext analyticContext = sqlExecutionContext.getAnalyticContext();
        if (analyticContext.isEmpty()) {
            throw SqlException.$(position, "analytic function called in non-analytic context, make sure to add OVER clause");
        }
        if (analyticContext.getPartitionByRecord() != null) {
            ArrayColumnTypes arrayColumnTypes = new ArrayColumnTypes();
            arrayColumnTypes.add(6);
            arrayColumnTypes.add(6);
            arrayColumnTypes.add(6);
            Map map = MapFactory.createMap(configuration, analyticContext.getPartitionByKeyTypes(), (ColumnTypes)arrayColumnTypes);
            return new RankFunction(map, analyticContext.getPartitionByRecord(), analyticContext.getPartitionBySink());
        }
        if (analyticContext.isOrdered()) {
            return new OrderRankFunction();
        }
        return new SequenceRankFunction();
    }

    private static class SequenceRankFunction
    extends LongFunction
    implements ScalarFunction,
    AnalyticFunction,
    Reopenable {
        private int columnIndex;

        @Override
        public void close() {
        }

        @Override
        public long getLong(Record rec) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void initRecordComparator(RecordComparatorCompiler recordComparatorCompiler, ArrayColumnTypes chainTypes, IntList order) {
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void pass1(Record record, long recordOffset, AnalyticSPI spi) {
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), 1L);
        }

        @Override
        public void pass2(Record record) {
        }

        @Override
        public void preparePass2(RecordCursor cursor) {
        }

        @Override
        public void reopen() {
        }

        @Override
        public void reset() {
        }

        @Override
        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(RankFunctionFactory.SIGNATURE);
        }
    }

    private static class RankFunction
    extends LongFunction
    implements ScalarFunction,
    AnalyticFunction,
    Reopenable {
        private static final int VAL_CURRENT_INDEX = 1;
        private static final int VAL_MAX_INDEX = 0;
        private static final int VAL_OFFSET = 2;
        private final Map map;
        private final VirtualRecord partitionByRecord;
        private final RecordSink partitionBySink;
        private int columnIndex;
        private RecordComparator recordComparator;

        public RankFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink) {
            this.partitionByRecord = partitionByRecord;
            this.partitionBySink = partitionBySink;
            this.map = map;
        }

        @Override
        public void close() {
            Misc.free(this.map);
            Misc.freeObjList(this.partitionByRecord.getFunctions());
        }

        @Override
        public long getLong(Record rec) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void initRecordComparator(RecordComparatorCompiler recordComparatorCompiler, ArrayColumnTypes chainTypes, IntList order) {
            this.recordComparator = recordComparatorCompiler.compile(chainTypes, order);
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void pass1(Record record, long recordOffset, AnalyticSPI spi) {
            this.partitionByRecord.of(record);
            MapKey mapKey = this.map.withKey();
            mapKey.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = mapKey.createValue();
            long maxIndex = 0L;
            if (mapValue.isNew()) {
                mapValue.putLong(0, 0L);
                mapValue.putLong(1, 0L);
                mapValue.putLong(2, 0L);
            } else {
                maxIndex = mapValue.getLong(0);
            }
            if (this.recordComparator == null) {
                Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), maxIndex + 1L);
            } else {
                long currentIndex = mapValue.getLong(1);
                long offset = mapValue.getLong(2);
                if (currentIndex == 0L) {
                    mapValue.putLong(1, 1L);
                    mapValue.putLong(2, recordOffset);
                } else {
                    this.recordComparator.setLeft(record);
                    if (this.recordComparator.compare(spi.getRecordAt(offset)) != 0) {
                        mapValue.putLong(1, maxIndex + 1L);
                        mapValue.putLong(2, recordOffset);
                    }
                }
                Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), mapValue.getLong(1));
            }
            mapValue.putLong(0, maxIndex + 1L);
        }

        @Override
        public void pass2(Record record) {
        }

        @Override
        public void preparePass2(RecordCursor cursor) {
        }

        @Override
        public void reopen() {
            this.map.reopen();
        }

        @Override
        public void reset() {
            this.map.close();
        }

        @Override
        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(RankFunctionFactory.SIGNATURE);
        }
    }

    private static class OrderRankFunction
    extends LongFunction
    implements ScalarFunction,
    AnalyticFunction,
    Reopenable {
        private int columnIndex;
        private long currentIndex = 0L;
        private long maxIndex = 0L;
        private long offset = 0L;
        private RecordComparator recordComparator;

        @Override
        public void close() {
        }

        @Override
        public long getLong(Record rec) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void initRecordComparator(RecordComparatorCompiler recordComparatorCompiler, ArrayColumnTypes chainTypes, IntList order) {
            this.recordComparator = recordComparatorCompiler.compile(chainTypes, order);
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void pass1(Record record, long recordOffset, AnalyticSPI spi) {
            if (this.recordComparator == null) {
                Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.maxIndex + 1L);
            } else {
                if (this.currentIndex == 0L) {
                    this.currentIndex = 1L;
                    this.offset = recordOffset;
                } else {
                    this.recordComparator.setLeft(record);
                    if (this.recordComparator.compare(spi.getRecordAt(this.offset)) != 0) {
                        this.currentIndex = this.maxIndex + 1L;
                        this.offset = recordOffset;
                    }
                }
                Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.currentIndex);
            }
            ++this.maxIndex;
        }

        @Override
        public void pass2(Record record) {
        }

        @Override
        public void preparePass2(RecordCursor cursor) {
        }

        @Override
        public void reopen() {
            this.reset();
        }

        @Override
        public void reset() {
            this.maxIndex = 0L;
            this.currentIndex = 0L;
            this.offset = 0L;
        }

        @Override
        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(RankFunctionFactory.SIGNATURE);
        }
    }
}

