/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.test;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.network.DefaultIODispatcherConfiguration;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.SuspendEvent;
import io.questdb.network.SuspendEventFactory;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class TestDataUnavailableFunctionFactory
implements FunctionFactory {
    public static SuspendEventCallback eventCallback;

    @Override
    public String getSignature() {
        return "test_data_unavailable(ll)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        long totalRows = args.getQuick(0).getLong(null);
        long backoffCount = args.getQuick(1).getLong(null);
        return new CursorFunction(new DataUnavailableRecordCursorFactory(totalRows, backoffCount, sqlExecutionContext.getCircuitBreaker()));
    }

    private static class LongConstRecord
    implements Record {
        private long value;

        private LongConstRecord() {
        }

        @Override
        public long getLong(int col) {
            return this.value;
        }

        @Override
        public long getRowId() {
            return this.value;
        }

        void of(long value) {
            this.value = value;
        }
    }

    private static class DataUnavailableRecordCursorFactory
    extends AbstractRecordCursorFactory {
        private static final RecordMetadata METADATA;
        private final DataUnavailableRecordCursor cursor;

        public DataUnavailableRecordCursorFactory(long totalRows, long backoffCount, SqlExecutionCircuitBreaker circuitBreaker) {
            super(METADATA);
            this.cursor = new DataUnavailableRecordCursor(totalRows, backoffCount, circuitBreaker);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
            this.cursor.reset();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type("test_data_unavailable");
            sink.meta("totalRows").val(this.cursor.totalRows);
            sink.meta("backoffCount").val(this.cursor.backoffCount);
        }

        static {
            GenericRecordMetadata metadata = new GenericRecordMetadata();
            metadata.add(0, new TableColumnMetadata("x", 6));
            metadata.add(1, new TableColumnMetadata("y", 6));
            metadata.add(2, new TableColumnMetadata("z", 6));
            METADATA = metadata;
        }
    }

    private static class DataUnavailableRecordCursor
    implements NoRandomAccessRecordCursor {
        private static final IODispatcherConfiguration ioDispatcherConfig = new DefaultIODispatcherConfiguration();
        private final long backoffCount;
        private final SqlExecutionCircuitBreaker circuitBreaker;
        private final LongConstRecord record = new LongConstRecord();
        private final long totalRows;
        private long attempts;
        private long rows;

        public DataUnavailableRecordCursor(long totalRows, long backoffCount, SqlExecutionCircuitBreaker circuitBreaker) {
            this.totalRows = totalRows;
            this.backoffCount = backoffCount;
            this.circuitBreaker = circuitBreaker;
        }

        @Override
        public void close() {
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
            if (this.rows >= this.totalRows) {
                return false;
            }
            if (this.attempts++ < this.backoffCount) {
                SuspendEvent event = SuspendEventFactory.newInstance(ioDispatcherConfig);
                if (eventCallback != null) {
                    eventCallback.onSuspendEvent(event);
                }
                throw DataUnavailableException.instance("foo", "2022-01-01", event);
            }
            ++this.rows;
            this.record.of(this.rows);
            this.attempts = 0L;
            return true;
        }

        public void reset() {
            this.rows = 0L;
            this.attempts = 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.reset();
        }
    }

    @FunctionalInterface
    public static interface SuspendEventCallback {
        public void onSuspendEvent(SuspendEvent var1);
    }
}

