/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordMetadata;
import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.columns.BinColumn;
import io.questdb.griffin.engine.functions.columns.BooleanColumn;
import io.questdb.griffin.engine.functions.columns.ByteColumn;
import io.questdb.griffin.engine.functions.columns.CharColumn;
import io.questdb.griffin.engine.functions.columns.DateColumn;
import io.questdb.griffin.engine.functions.columns.DoubleColumn;
import io.questdb.griffin.engine.functions.columns.FloatColumn;
import io.questdb.griffin.engine.functions.columns.GeoByteColumn;
import io.questdb.griffin.engine.functions.columns.GeoIntColumn;
import io.questdb.griffin.engine.functions.columns.GeoLongColumn;
import io.questdb.griffin.engine.functions.columns.GeoShortColumn;
import io.questdb.griffin.engine.functions.columns.IntColumn;
import io.questdb.griffin.engine.functions.columns.Long128Column;
import io.questdb.griffin.engine.functions.columns.Long256Column;
import io.questdb.griffin.engine.functions.columns.LongColumn;
import io.questdb.griffin.engine.functions.columns.ShortColumn;
import io.questdb.griffin.engine.functions.columns.StrColumn;
import io.questdb.griffin.engine.functions.columns.TimestampColumn;
import io.questdb.griffin.engine.functions.columns.UuidColumn;
import io.questdb.griffin.engine.groupby.MapSymbolColumn;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class GroupByUtils {
    public static void prepareGroupByFunctions(QueryModel model, RecordMetadata metadata, FunctionParser functionParser, SqlExecutionContext executionContext, ObjList<GroupByFunction> groupByFunctions, IntList groupByFunctionPositions, ArrayColumnTypes valueTypes) throws SqlException {
        groupByFunctionPositions.clear();
        ObjList<QueryColumn> columns = model.getColumns();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn column = columns.getQuick(i);
            ExpressionNode node = column.getAst();
            if (node.type == 4) continue;
            ExpressionNode columnAst = column.getAst();
            Function function = functionParser.parseFunction(columnAst, metadata, executionContext);
            assert (function instanceof GroupByFunction);
            GroupByFunction func = (GroupByFunction)function;
            func.pushValueTypes(valueTypes);
            groupByFunctions.add(func);
            groupByFunctionPositions.add(columnAst.position);
        }
    }

    public static void prepareGroupByRecordFunctions(@NotNull QueryModel model, RecordMetadata metadata, @NotNull ListColumnFilter listColumnFilter, ObjList<GroupByFunction> groupByFunctions, IntList groupByFunctionPositions, ObjList<Function> recordFunctions, IntList recordFunctionPositions, GenericRecordMetadata groupByMetadata, ArrayColumnTypes keyTypes, int keyColumnIndex, boolean timestampUnimportant, int timestampIndex) throws SqlException {
        recordFunctionPositions.clear();
        ObjList<QueryColumn> columns = model.getColumns();
        int valueColumnIndex = 0;
        int inferredKeyColumnCount = 0;
        int lastIndex = -1;
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            int type;
            QueryColumn column = columns.getQuick(i);
            ExpressionNode node = column.getAst();
            if (node.type == 4) {
                int index = metadata.getColumnIndexQuiet(node.token);
                if (index == -1) {
                    throw SqlException.invalidColumn(node.position, node.token);
                }
                type = metadata.getColumnType(index);
                if (index != timestampIndex || timestampUnimportant) {
                    ScalarFunction fun;
                    if (lastIndex != index) {
                        listColumnFilter.add(index + 1);
                        keyTypes.add(type);
                        ++keyColumnIndex;
                        lastIndex = index;
                    }
                    switch (ColumnType.tagOf(type)) {
                        case 1: {
                            fun = BooleanColumn.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 2: {
                            fun = ByteColumn.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 3: {
                            fun = ShortColumn.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 4: {
                            fun = CharColumn.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 5: {
                            fun = IntColumn.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 6: {
                            fun = LongColumn.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 9: {
                            fun = FloatColumn.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 10: {
                            fun = DoubleColumn.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 11: {
                            fun = StrColumn.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 12: {
                            fun = new MapSymbolColumn(keyColumnIndex - 1, index, metadata.isSymbolTableStatic(index));
                            break;
                        }
                        case 7: {
                            fun = DateColumn.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 8: {
                            fun = TimestampColumn.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 13: {
                            fun = Long256Column.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 14: {
                            fun = GeoByteColumn.newInstance(keyColumnIndex - 1, type);
                            break;
                        }
                        case 15: {
                            fun = GeoShortColumn.newInstance(keyColumnIndex - 1, type);
                            break;
                        }
                        case 16: {
                            fun = GeoIntColumn.newInstance(keyColumnIndex - 1, type);
                            break;
                        }
                        case 17: {
                            fun = GeoLongColumn.newInstance(keyColumnIndex - 1, type);
                            break;
                        }
                        case 24: {
                            fun = Long128Column.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        case 19: {
                            fun = UuidColumn.newInstance(keyColumnIndex - 1);
                            break;
                        }
                        default: {
                            fun = BinColumn.newInstance(keyColumnIndex - 1);
                        }
                    }
                    recordFunctions.add(fun);
                    recordFunctionPositions.add(node.position);
                } else {
                    recordFunctions.add(null);
                    groupByFunctionPositions.add(0);
                    if (groupByMetadata.getTimestampIndex() == -1) {
                        groupByMetadata.setTimestampIndex(i);
                    }
                    assert (ColumnType.tagOf(type) == 8);
                }
                if (column.getAlias() == null) {
                    groupByMetadata.add(AbstractRecordMetadata.copyOf(metadata, index));
                } else {
                    groupByMetadata.add(new TableColumnMetadata(Chars.toString(column.getAlias()), type, metadata.isColumnIndexed(index), metadata.getIndexValueBlockCapacity(index), metadata.isSymbolTableStatic(index), metadata.getMetadata(index)));
                }
                ++inferredKeyColumnCount;
                continue;
            }
            GroupByFunction groupByFunction = groupByFunctions.getQuick(valueColumnIndex);
            recordFunctions.add(groupByFunction);
            recordFunctionPositions.add(groupByFunctionPositions.getQuick(valueColumnIndex++));
            type = groupByFunction.getType();
            groupByMetadata.add(new TableColumnMetadata(Chars.toString(column.getName()), type, false, 0, groupByFunction instanceof SymbolFunction && ((SymbolFunction)((Object)groupByFunction)).isSymbolTableStatic(), groupByFunction.getMetadata()));
        }
        GroupByUtils.validateGroupByColumns(model, inferredKeyColumnCount);
    }

    public static void toTop(ObjList<? extends Function> args) {
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            args.getQuick(i).toTop();
        }
    }

    public static void validateGroupByColumns(@NotNull QueryModel model, int inferredKeyColumnCount) throws SqlException {
        QueryModel chooseModel;
        ObjList<ExpressionNode> groupByColumns = model.getGroupBy();
        int explicitKeyColumnCount = groupByColumns.size();
        if (explicitKeyColumnCount == 0) {
            return;
        }
        QueryModel nested = model.getNestedModel();
        for (chooseModel = model; chooseModel != null && chooseModel.getSelectModelType() != 1 && chooseModel.getSelectModelType() != 0; chooseModel = chooseModel.getNestedModel()) {
        }
        block6: for (int i = 0; i < explicitKeyColumnCount; ++i) {
            ExpressionNode key = groupByColumns.getQuick(i);
            switch (key.type) {
                case 4: {
                    int dotIndex = Chars.indexOf(key.token, '.');
                    if (dotIndex > -1) {
                        int aliasIndex = model.getModelAliasIndex(key.token, 0, dotIndex);
                        if (aliasIndex > -1) {
                            int refColumn = model.getAliasToColumnMap().keyIndex(key.token);
                            if (refColumn > -1) {
                                refColumn = model.getAliasToColumnMap().keyIndex(key.token, dotIndex + 1, key.token.length());
                            }
                            if (refColumn <= -1) continue block6;
                            throw SqlException.$(key.position, "group by column does not match any key column is select statement");
                        }
                        if (chooseModel != null && chooseModel.getColumnNameToAliasMap().keyIndex(key.token) < 0) continue block6;
                        throw SqlException.$(key.position, "invalid column reference");
                    }
                    int refColumn = model.getAliasToColumnMap().keyIndex(key.token);
                    if (refColumn > -1) {
                        throw SqlException.$(key.position, "group by column does not match any key column is select statement");
                    }
                    QueryColumn qc = model.getAliasToColumnMap().valueAt(refColumn);
                    if (qc.getAst().type == 4 || qc.getAst().type == 2) continue block6;
                    throw SqlException.$(key.position, "group by column references aggregate expression");
                }
                case 6: {
                    throw SqlException.$(key.position, "bind variable is not allowed here");
                }
                case 1: 
                case 2: 
                case 8: {
                    ObjList<QueryColumn> availableColumns = nested.getTopDownColumns();
                    boolean invalid = true;
                    int n = availableColumns.size();
                    for (int j = 0; j < n; ++j) {
                        QueryColumn qc = availableColumns.getQuick(j);
                        if (qc.getAst().type != key.type || !ExpressionNode.compareNodesGroupBy(key, qc.getAst(), chooseModel)) continue;
                        invalid = false;
                        break;
                    }
                    if (!invalid) continue block6;
                    throw SqlException.$(key.position, "group by expression does not match anything select in statement");
                }
                default: {
                    throw SqlException.$(key.position, "unsupported type of expression");
                }
            }
        }
        if (explicitKeyColumnCount < inferredKeyColumnCount) {
            throw SqlException.$(model.getModelPosition(), "not enough columns in group by");
        }
    }
}

