/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.index;

import v14.h2.engine.Session;
import v14.h2.index.Cursor;
import v14.h2.index.VirtualTableIndex;
import v14.h2.message.DbException;
import v14.h2.result.ResultInterface;
import v14.h2.result.Row;
import v14.h2.result.SearchRow;
import v14.h2.value.Value;

class VirtualTableCursor
implements Cursor {
    private final VirtualTableIndex index;
    private final SearchRow first;
    private final SearchRow last;
    final Session session;
    private final ResultInterface result;
    Value[] values;
    Row row;

    VirtualTableCursor(VirtualTableIndex virtualTableIndex, SearchRow searchRow, SearchRow searchRow2, Session session, ResultInterface resultInterface) {
        this.index = virtualTableIndex;
        this.first = searchRow;
        this.last = searchRow2;
        this.session = session;
        this.result = resultInterface;
    }

    @Override
    public Row get() {
        if (this.values == null) {
            return null;
        }
        if (this.row == null) {
            this.row = this.session.createRow(this.values, 1);
        }
        return this.row;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.get();
    }

    @Override
    public boolean next() {
        SearchRow searchRow = this.first;
        SearchRow searchRow2 = this.last;
        if (searchRow == null && searchRow2 == null) {
            return this.nextImpl();
        }
        while (this.nextImpl()) {
            int n;
            Row row = this.get();
            if (searchRow != null && (n = this.index.compareRows(row, searchRow)) < 0 || searchRow2 != null && (n = this.index.compareRows(row, searchRow2)) > 0) continue;
            return true;
        }
        return false;
    }

    private boolean nextImpl() {
        this.row = null;
        this.values = this.result != null && this.result.next() ? this.result.currentRow() : null;
        return this.values != null;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

