/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.mvstore;

import v14.h2.mvstore.Page;

public final class RootReference {
    public final Page root;
    public final long version;
    private final byte holdCount;
    private final long ownerId;
    volatile RootReference previous;
    final long updateCounter;
    final long updateAttemptCounter;
    private final byte appendCounter;

    RootReference(Page page, long l) {
        this.root = page;
        this.version = l;
        this.previous = null;
        this.updateCounter = 1L;
        this.updateAttemptCounter = 1L;
        this.holdCount = 0;
        this.ownerId = 0L;
        this.appendCounter = 0;
    }

    private RootReference(RootReference rootReference, Page page, long l) {
        this.root = page;
        this.version = rootReference.version;
        this.previous = rootReference.previous;
        this.updateCounter = rootReference.updateCounter + 1L;
        this.updateAttemptCounter = rootReference.updateAttemptCounter + l;
        this.holdCount = 0;
        this.ownerId = 0L;
        this.appendCounter = rootReference.appendCounter;
    }

    private RootReference(RootReference rootReference, int n) {
        this.root = rootReference.root;
        this.version = rootReference.version;
        this.previous = rootReference.previous;
        this.updateCounter = rootReference.updateCounter + 1L;
        this.updateAttemptCounter = rootReference.updateAttemptCounter + (long)n;
        assert (rootReference.holdCount == 0 || rootReference.ownerId == Thread.currentThread().getId()) : Thread.currentThread().getId() + " " + rootReference;
        this.holdCount = (byte)(rootReference.holdCount + 1);
        this.ownerId = Thread.currentThread().getId();
        this.appendCounter = rootReference.appendCounter;
    }

    private RootReference(RootReference rootReference, Page page, boolean bl, int n) {
        this.root = page;
        this.version = rootReference.version;
        this.previous = rootReference.previous;
        this.updateCounter = rootReference.updateCounter;
        this.updateAttemptCounter = rootReference.updateAttemptCounter;
        assert (rootReference.holdCount > 0 && rootReference.ownerId == Thread.currentThread().getId()) : Thread.currentThread().getId() + " " + rootReference;
        this.holdCount = (byte)(rootReference.holdCount - (bl ? (byte)0 : 1));
        this.ownerId = this.holdCount == 0 ? 0L : Thread.currentThread().getId();
        this.appendCounter = (byte)n;
    }

    private RootReference(RootReference rootReference, long l, int n) {
        RootReference rootReference2;
        RootReference rootReference3 = rootReference;
        while ((rootReference2 = rootReference3.previous) != null && rootReference2.root == rootReference.root) {
            rootReference3 = rootReference2;
        }
        this.root = rootReference.root;
        this.version = l;
        this.previous = rootReference3;
        this.updateCounter = rootReference.updateCounter + 1L;
        this.updateAttemptCounter = rootReference.updateAttemptCounter + (long)n;
        this.holdCount = rootReference.holdCount == 0 ? (byte)0 : (byte)(rootReference.holdCount - 1);
        long l2 = this.ownerId = this.holdCount == 0 ? 0L : rootReference.ownerId;
        assert (rootReference.appendCounter == 0);
        this.appendCounter = 0;
    }

    RootReference updateRootPage(Page page, long l) {
        RootReference rootReference;
        if (this.holdCount == 0 && this.root.map.compareAndSetRoot(this, rootReference = new RootReference(this, page, l))) {
            return rootReference;
        }
        return null;
    }

    RootReference tryLock(int n) {
        RootReference rootReference;
        if ((this.holdCount == 0 || this.ownerId == Thread.currentThread().getId()) && this.root.map.compareAndSetRoot(this, rootReference = new RootReference(this, n))) {
            return rootReference;
        }
        return null;
    }

    RootReference tryUnlockAndUpdateVersion(long l, int n) {
        RootReference rootReference;
        if ((this.holdCount == 0 || this.ownerId == Thread.currentThread().getId()) && this.root.map.compareAndSetRoot(this, rootReference = new RootReference(this, l, n))) {
            return rootReference;
        }
        return null;
    }

    RootReference updatePageAndLockedStatus(Page page, boolean bl, int n) {
        assert (this.isLockedByCurrentThread()) : this;
        RootReference rootReference = new RootReference(this, page, bl, n);
        if (this.root.map.compareAndSetRoot(this, rootReference)) {
            return rootReference;
        }
        return null;
    }

    void removeUnusedOldVersions(long l) {
        RootReference rootReference = this;
        while (rootReference != null) {
            if (rootReference.version < l) {
                RootReference rootReference2;
                assert ((rootReference2 = rootReference.previous) == null || rootReference2.getAppendCounter() == 0) : l + " " + rootReference.previous;
                rootReference.previous = null;
            }
            rootReference = rootReference.previous;
        }
    }

    boolean isLocked() {
        return this.holdCount != 0;
    }

    public boolean isLockedByCurrentThread() {
        return this.holdCount != 0 && this.ownerId == Thread.currentThread().getId();
    }

    long getVersion() {
        RootReference rootReference = this.previous;
        return rootReference == null || rootReference.root != this.root || rootReference.appendCounter != this.appendCounter ? this.version : rootReference.version;
    }

    boolean hasChangesSince(long l) {
        return (!this.root.isSaved() ? this.getTotalCount() > 0L : this.getAppendCounter() > 0) || this.getVersion() > l;
    }

    int getAppendCounter() {
        return this.appendCounter & 0xFF;
    }

    public boolean needFlush() {
        return this.appendCounter != 0;
    }

    public long getTotalCount() {
        return this.root.getTotalCount() + (long)this.getAppendCounter();
    }

    public String toString() {
        return "RootReference(" + System.identityHashCode(this.root) + ", v=" + this.version + ", owner=" + this.ownerId + (this.ownerId == Thread.currentThread().getId() ? "(current)" : "") + ", holdCnt=" + this.holdCount + ", keys=" + this.root.getTotalCount() + ", append=" + this.getAppendCounter() + ")";
    }
}

