/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.SerializedRepositoryRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.flowfile.attributes.CoreAttributes;

public class ReconstitutedSerializedRepositoryRecord
implements SerializedRepositoryRecord {
    private final String queueIdentifier;
    private final RepositoryRecordType type;
    private final FlowFileRecord flowFile;
    private final String swapLocation;

    private ReconstitutedSerializedRepositoryRecord(Builder builder) {
        this.queueIdentifier = builder.queueIdentifier;
        this.type = builder.type;
        this.flowFile = builder.flowFile;
        this.swapLocation = builder.swapLocation;
    }

    @Override
    public String getQueueIdentifier() {
        return this.queueIdentifier;
    }

    @Override
    public RepositoryRecordType getType() {
        return this.type;
    }

    @Override
    public ContentClaim getContentClaim() {
        return this.flowFile.getContentClaim();
    }

    @Override
    public long getClaimOffset() {
        return this.flowFile.getContentClaimOffset();
    }

    @Override
    public FlowFileRecord getFlowFileRecord() {
        return this.flowFile;
    }

    @Override
    public boolean isMarkedForAbort() {
        return false;
    }

    @Override
    public boolean isAttributesChanged() {
        return false;
    }

    @Override
    public String getSwapLocation() {
        return this.swapLocation;
    }

    public String toString() {
        return "ReconstitutedSerializedRepositoryRecord[recordType=" + this.type + ", queueId=" + this.queueIdentifier + ", flowFileUuid=" + this.flowFile.getAttribute(CoreAttributes.UUID.key()) + ", attributesChanged=" + this.isAttributesChanged() + "]";
    }

    public static class Builder {
        private String queueIdentifier;
        private RepositoryRecordType type;
        private FlowFileRecord flowFile;
        private String swapLocation;

        public Builder queueIdentifier(String queueIdentifier) {
            this.queueIdentifier = queueIdentifier;
            return this;
        }

        public Builder type(RepositoryRecordType type) {
            this.type = type;
            return this;
        }

        public Builder flowFileRecord(FlowFileRecord flowFileRecord) {
            this.flowFile = flowFileRecord;
            return this;
        }

        public Builder swapLocation(String swapLocation) {
            this.swapLocation = swapLocation;
            return this;
        }

        public ReconstitutedSerializedRepositoryRecord build() {
            return new ReconstitutedSerializedRepositoryRecord(this);
        }
    }
}

