/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import org.apache.nifi.controller.repository.RepositoryRecordSerdeFactory;
import org.apache.nifi.controller.repository.SchemaRepositoryRecordSerde;
import org.apache.nifi.controller.repository.SerializedRepositoryRecord;
import org.apache.nifi.controller.repository.WriteAheadRepositoryRecordSerde;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.repository.schema.FieldCache;
import org.apache.nifi.repository.schema.NoOpFieldCache;
import org.wali.SerDe;
import org.wali.UpdateType;

public class StandardRepositoryRecordSerdeFactory
implements RepositoryRecordSerdeFactory {
    private static final String LEGACY_SERDE_ENCODING_NAME = "org.apache.nifi.controller.repository.WriteAheadFlowFileRepository$WriteAheadRecordSerde";
    private final ResourceClaimManager resourceClaimManager;
    private final FieldCache fieldCache;

    public StandardRepositoryRecordSerdeFactory(ResourceClaimManager claimManager) {
        this(claimManager, (FieldCache)new NoOpFieldCache());
    }

    public StandardRepositoryRecordSerdeFactory(ResourceClaimManager claimManager, FieldCache fieldCache) {
        this.resourceClaimManager = claimManager;
        this.fieldCache = fieldCache;
    }

    public SerDe<SerializedRepositoryRecord> createSerDe(String encodingName) {
        if (encodingName == null || SchemaRepositoryRecordSerde.class.getName().equals(encodingName)) {
            SchemaRepositoryRecordSerde serde = new SchemaRepositoryRecordSerde(this.resourceClaimManager, this.fieldCache);
            return serde;
        }
        if (WriteAheadRepositoryRecordSerde.class.getName().equals(encodingName) || LEGACY_SERDE_ENCODING_NAME.equals(encodingName)) {
            WriteAheadRepositoryRecordSerde serde = new WriteAheadRepositoryRecordSerde(this.resourceClaimManager);
            return serde;
        }
        throw new IllegalArgumentException("Cannot create Deserializer for Repository Records because the encoding '" + encodingName + "' is not known");
    }

    @Override
    public Long getRecordIdentifier(SerializedRepositoryRecord record) {
        return record.getFlowFileRecord().getId();
    }

    public UpdateType getUpdateType(SerializedRepositoryRecord record) {
        switch (record.getType()) {
            case CONTENTMISSING: 
            case DELETE: {
                return UpdateType.DELETE;
            }
            case CREATE: {
                return UpdateType.CREATE;
            }
            case UPDATE: {
                return UpdateType.UPDATE;
            }
            case SWAP_OUT: {
                return UpdateType.SWAP_OUT;
            }
            case SWAP_IN: {
                return UpdateType.SWAP_IN;
            }
        }
        return null;
    }

    public String getLocation(SerializedRepositoryRecord record) {
        return record.getSwapLocation();
    }
}

