/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractIndexReader;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;

public class ConcurrentBitmapIndexFwdReader
extends AbstractIndexReader {
    private static final Log LOG = LogFactory.getLog(ConcurrentBitmapIndexFwdReader.class);
    private final Cursor cursor = new Cursor();

    public ConcurrentBitmapIndexFwdReader() {
    }

    public ConcurrentBitmapIndexFwdReader(CairoConfiguration configuration, Path path, CharSequence name, long columnNameTxn, long unIndexedNullCount) {
        this.of(configuration, path, name, columnNameTxn, unIndexedNullCount, -1L);
    }

    @Override
    public RowCursor getCursor(boolean cachedInstance, int key, long minValue, long maxValue) {
        return this.initCursor(cachedInstance ? this.cursor : null, key, minValue, maxValue);
    }

    public RowCursor initCursor(RowCursor rowCursor, int key, long minValue, long maxValue) {
        Cursor cursor = null;
        if (rowCursor != null && rowCursor != EmptyRowCursor.INSTANCE) {
            cursor = (Cursor)rowCursor;
            assert (cursor.owner() == this);
        }
        if (key == 0 && this.unIndexedNullCount > 0L && minValue < this.unIndexedNullCount) {
            if (cursor == null) {
                cursor = new Cursor();
            }
            cursor.of(key, 0L, maxValue, this.keyCount, minValue, this.unIndexedNullCount);
            return cursor;
        }
        if (key < this.keyCount) {
            if (cursor == null) {
                cursor = new Cursor();
            }
            cursor.of(key, minValue, maxValue, this.keyCount, 0L, 0L);
            return cursor;
        }
        return EmptyRowCursor.INSTANCE;
    }

    private class Cursor
    implements RowCursor {
        protected long next;
        protected long position;
        protected long valueCount;
        private long maxValue;
        private long nullCount;
        private long nullPos;
        private long valueBlockOffset;
        private final BitmapIndexUtils.ValueBlockSeeker SEEKER = this::seekValue;

        private Cursor() {
        }

        @Override
        public boolean hasNext() {
            if (this.nullPos < this.nullCount) {
                this.next = this.nullPos++;
                return true;
            }
            if (this.position < this.valueCount) {
                long cellIndex;
                long result;
                if ((result = ConcurrentBitmapIndexFwdReader.this.valueMem.getLong(this.valueBlockOffset + (cellIndex = this.getValueCellIndex(this.position++)) * 8L)) > this.maxValue) {
                    this.valueCount = 0L;
                    return false;
                }
                if (cellIndex == (long)ConcurrentBitmapIndexFwdReader.this.blockValueCountMod && this.position < this.valueCount && !this.jumpToNextValueBlock()) {
                    this.valueCount = 0L;
                    return false;
                }
                this.next = result;
                return true;
            }
            return false;
        }

        @Override
        public long next() {
            return this.next;
        }

        private long getValueCellIndex(long absoluteValueIndex) {
            return absoluteValueIndex & (long)ConcurrentBitmapIndexFwdReader.this.blockValueCountMod;
        }

        private boolean jumpToNextValueBlock() {
            long nextBlock = ConcurrentBitmapIndexFwdReader.this.valueMem.getLong(this.valueBlockOffset + (long)ConcurrentBitmapIndexFwdReader.this.blockCapacity - 16L + 8L);
            if (nextBlock >= ConcurrentBitmapIndexFwdReader.this.valueMem.size()) {
                return false;
            }
            this.valueBlockOffset = nextBlock;
            return true;
        }

        private ConcurrentBitmapIndexFwdReader owner() {
            return ConcurrentBitmapIndexFwdReader.this;
        }

        private void seekValue(long count, long offset) {
            this.position = count;
            this.valueBlockOffset = offset;
        }

        void of(int key, long minValue, long maxValue, long keyCount, long nullPos, long nullCount) {
            this.nullPos = nullPos;
            this.nullCount = nullCount;
            if (keyCount == 0L) {
                this.valueCount = 0L;
            } else {
                long valueBlockOffset;
                long valueCount;
                block7: {
                    assert (key > -1) : "key must be positive integer: " + key;
                    assert ((long)key < keyCount) : "key must be within the last known boundary: " + key + ", " + keyCount;
                    long offset = BitmapIndexUtils.getKeyEntryOffset(key);
                    long deadline = ConcurrentBitmapIndexFwdReader.this.clock.getTicks() + ConcurrentBitmapIndexFwdReader.this.spinLockTimeoutUs;
                    do {
                        valueCount = ConcurrentBitmapIndexFwdReader.this.keyMem.getLong(offset + 0L);
                        Unsafe.getUnsafe().loadFence();
                        if (ConcurrentBitmapIndexFwdReader.this.keyMem.getLong(offset + 24L) != valueCount) continue;
                        valueBlockOffset = ConcurrentBitmapIndexFwdReader.this.keyMem.getLong(offset + 8L);
                        Unsafe.getUnsafe().loadFence();
                        if (ConcurrentBitmapIndexFwdReader.this.keyMem.getLong(offset + 0L) == valueCount) break block7;
                    } while (ConcurrentBitmapIndexFwdReader.this.clock.getTicks() <= deadline);
                    LOG.error().$("cursor could not consistently read index header [corrupt?]").$(" [timeout=").$(ConcurrentBitmapIndexFwdReader.this.spinLockTimeoutUs).utf8("\u03bcs, key=").$(key).$(", offset=").$(offset).$(']').$();
                    throw CairoException.critical(0).put("cursor could not consistently read index header [corrupt?]");
                }
                this.valueCount = valueCount;
                if (valueCount > 0L) {
                    BitmapIndexUtils.seekValueBlockLTR(valueCount, valueBlockOffset, ConcurrentBitmapIndexFwdReader.this.valueMem, minValue, ConcurrentBitmapIndexFwdReader.this.blockValueCountMod, this.SEEKER);
                } else {
                    this.seekValue(valueCount, valueBlockOffset);
                }
                this.maxValue = maxValue;
            }
        }
    }
}

