/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import org.jetbrains.annotations.Nullable;

public class TableColumnMetadata
implements Plannable {
    @Nullable
    private final RecordMetadata metadata;
    private final boolean symbolTableStatic;
    private final int writerIndex;
    private int indexValueBlockCapacity;
    private boolean indexed;
    private String name;
    private int type;

    public TableColumnMetadata(String name, int type) {
        this(name, type, null);
    }

    public TableColumnMetadata(String name, int type, @Nullable RecordMetadata metadata) {
        this(name, type, false, 0, false, metadata, -1);
        assert (!ColumnType.isSymbol(type));
    }

    public TableColumnMetadata(String name, int type, boolean indexFlag, int indexValueBlockCapacity, boolean symbolTableStatic, @Nullable RecordMetadata metadata) {
        this(name, type, indexFlag, indexValueBlockCapacity, symbolTableStatic, metadata, -1);
    }

    public TableColumnMetadata(String name, int type, boolean indexFlag, int indexValueBlockCapacity, boolean symbolTableStatic, @Nullable RecordMetadata metadata, int writerIndex) {
        this.name = name;
        this.type = type;
        this.indexed = indexFlag;
        this.indexValueBlockCapacity = indexValueBlockCapacity;
        this.symbolTableStatic = symbolTableStatic;
        this.metadata = GenericRecordMetadata.copyOf(metadata);
        this.writerIndex = writerIndex;
    }

    public int getIndexValueBlockCapacity() {
        return this.indexValueBlockCapacity;
    }

    @Nullable
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getWriterIndex() {
        return this.writerIndex;
    }

    public boolean isDeleted() {
        return this.type < 0;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public boolean isSymbolTableStatic() {
        return this.symbolTableStatic;
    }

    public void markDeleted() {
        this.type = -Math.abs(this.type);
    }

    public void setIndexValueBlockCapacity(int indexValueBlockCapacity) {
        this.indexValueBlockCapacity = indexValueBlockCapacity;
    }

    public void setIndexed(boolean value) {
        this.indexed = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.name);
    }
}

