/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mig;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.mig.Mig505;
import io.questdb.cairo.mig.Mig506;
import io.questdb.cairo.mig.Mig600;
import io.questdb.cairo.mig.Mig605;
import io.questdb.cairo.mig.Mig607;
import io.questdb.cairo.mig.Mig608;
import io.questdb.cairo.mig.Mig609;
import io.questdb.cairo.mig.Mig614;
import io.questdb.cairo.mig.Mig620;
import io.questdb.cairo.mig.MigrationAction;
import io.questdb.cairo.mig.MigrationContext;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

public class EngineMigration {
    private static final Log LOG = LogFactory.getLog(EngineMigration.class);
    private static final IntObjHashMap<MigrationAction> MIGRATIONS = new IntObjHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateEngineTo(CairoEngine engine, int latestVersion, boolean force) {
        block44: {
            FilesFacade ff = engine.getConfiguration().getFilesFacade();
            CairoConfiguration configuration = engine.getConfiguration();
            int tempMemSize = 8;
            long mem = Unsafe.malloc(tempMemSize, 44);
            try (MemoryARW virtualMem = Vm.getARWInstance(ff.getPageSize(), Integer.MAX_VALUE, 45);
                 Path path = new Path();
                 MemoryMARW rwMemory = Vm.getMARWInstance();){
                int currentVersion;
                MigrationContext context = new MigrationContext(engine, mem, tempMemSize, virtualMem, rwMemory);
                path.of(configuration.getRoot());
                path.concat("_upgrade.d").$();
                boolean existed = !force && ff.exists(path);
                int upgradeFd = TableUtils.openFileRWOrFail(ff, path, configuration.getWriterFileOpenOpts());
                LOG.debug().$("open [fd=").$(upgradeFd).$(", path=").$(path).I$();
                if (existed && (currentVersion = TableUtils.readIntOrFail(ff, upgradeFd, 0L, mem, path)) >= latestVersion) {
                    LOG.info().$("table structures are up to date").$();
                    ff.close(upgradeFd);
                    upgradeFd = -1;
                }
                if (upgradeFd == -1) break block44;
                try {
                    LOG.info().$("upgrading database [version=").$(latestVersion).I$();
                    if (EngineMigration.upgradeTables(context, latestVersion)) {
                        TableUtils.writeIntOrFail(ff, upgradeFd, 0L, latestVersion, mem, path);
                    }
                }
                finally {
                    Vm.bestEffortClose(ff, LOG, upgradeFd, 4L);
                }
            }
            finally {
                Unsafe.free(mem, tempMemSize, 44);
            }
        }
    }

    @Nullable
    private static MigrationAction getMigrationToVersion(int version) {
        return MIGRATIONS.get(version);
    }

    private static boolean upgradeTables(MigrationContext context, int latestVersion) {
        FilesFacade ff = context.getFf();
        CharSequence root = context.getConfiguration().getRoot();
        long mem = context.getTempMemory(8);
        AtomicBoolean updateSuccess = new AtomicBoolean(true);
        try (Path path = new Path();
             Path copyPath = new Path();){
            path.of(root);
            copyPath.of(root);
            int rootLen = path.length();
            ff.iterateDir(path.$(), (pUtf8NameZ, type) -> {
                block9: {
                    if (ff.isDirOrSoftLinkDirNoDots(path, rootLen, pUtf8NameZ, type)) {
                        copyPath.trimTo(rootLen);
                        copyPath.concat(pUtf8NameZ);
                        int tablePlen = path.length();
                        if (ff.exists(path.concat("_meta").$())) {
                            int fdMeta = TableUtils.openFileRWOrFail(ff, path, context.getConfiguration().getWriterFileOpenOpts());
                            try {
                                int currentTableVersion = TableUtils.readIntOrFail(ff, fdMeta, 12L, mem, path);
                                if (currentTableVersion >= latestVersion) break block9;
                                LOG.info().$("upgrading [path=").utf8(copyPath.$()).$(", fromVersion=").$(currentTableVersion).$(", toVersion=").$(latestVersion).I$();
                                copyPath.trimTo(tablePlen);
                                EngineMigration.backupFile(ff, path, copyPath, "_meta", currentTableVersion);
                                path.trimTo(tablePlen);
                                context.of(path, copyPath, fdMeta);
                                for (int ver = currentTableVersion + 1; ver <= latestVersion; ++ver) {
                                    MigrationAction migration = EngineMigration.getMigrationToVersion(ver);
                                    if (migration != null) {
                                        try {
                                            LOG.info().$("upgrading table [path=").utf8(path).$(", toVersion=").$(ver).I$();
                                            migration.migrate(context);
                                            path.trimTo(tablePlen);
                                            copyPath.trimTo(tablePlen);
                                        }
                                        catch (Throwable e) {
                                            LOG.error().$("failed to upgrade table [path=").utf8(path.trimTo(tablePlen)).$(", e=").$(e).I$();
                                            throw e;
                                        }
                                    }
                                    path.trimTo(tablePlen).concat("_meta").$();
                                    LOG.info().$("upgrading table _meta [path=").utf8(path).$(", toVersion=").$(ver).I$();
                                    TableUtils.writeIntOrFail(ff, fdMeta, 12L, ver, mem, path);
                                    path.trimTo(tablePlen);
                                }
                            }
                            finally {
                                ff.close(fdMeta);
                                path.trimTo(tablePlen);
                                copyPath.trimTo(tablePlen);
                            }
                        }
                    }
                }
            });
            LOG.info().$("upgraded tables to ").$(latestVersion).$();
        }
        return updateSuccess.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void backupFile(FilesFacade ff, Path src, Path toTemp, String backupName, int version) {
        int copyPathLen = toTemp.length();
        try {
            toTemp.concat(backupName).put(".v").put(version);
            int versionLen = toTemp.length();
            int i = 1;
            while (ff.exists(toTemp.$())) {
                LOG.info().$("backup dest exists [to=").$(toTemp).I$();
                toTemp.trimTo(versionLen).put('.').put(i);
                ++i;
            }
            LOG.info().$("backing up [file=").utf8(src).$(", to=").utf8(toTemp).I$();
            if (ff.copy(src.$(), toTemp) < 0) {
                throw CairoException.critical(ff.errno()).put("Cannot backup transaction file [to=").put(toTemp).put(']');
            }
        }
        finally {
            toTemp.trimTo(copyPathLen);
        }
    }

    static {
        MIGRATIONS.put(417, Mig505::migrate);
        MIGRATIONS.put(418, Mig506::migrate);
        MIGRATIONS.put(419, Mig600::migrate);
        MIGRATIONS.put(420, Mig605::migrate);
        MIGRATIONS.put(422, Mig607::migrate);
        MIGRATIONS.put(423, Mig608::migrate);
        MIGRATIONS.put(424, Mig609::migrate);
        MIGRATIONS.put(425, Mig614::migrate);
        MIGRATIONS.put(426, Mig620::migrate);
    }
}

