/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.cutlass.text.types.TimestampCompatibleAdapter;
import io.questdb.griffin.SqlKeywords;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.DirectByteCharSequence;

public final class IntAdapter
extends AbstractTypeAdapter
implements TimestampCompatibleAdapter {
    public static final IntAdapter INSTANCE = new IntAdapter();

    private IntAdapter() {
    }

    @Override
    public long getTimestamp(DirectByteCharSequence value) throws Exception {
        return this.parseInt(value);
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public boolean probe(DirectByteCharSequence text) {
        if (text.length() > 2 && text.charAt(0) == '0' && text.charAt(1) != '.') {
            return false;
        }
        try {
            Numbers.parseInt(text);
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectByteCharSequence value) throws Exception {
        row.putInt(column, SqlKeywords.isNullKeyword(value) ? Integer.MIN_VALUE : this.parseInt(value));
    }

    private int parseInt(DirectByteCharSequence value) throws NumericException {
        return Numbers.parseInt(value);
    }
}

