/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.BasePlanSink;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.Sinkable;

public class TextPlanSink
extends BasePlanSink {
    private final IntList eolIndexes = new IntList();
    private String attrIndent = "  ";
    private String childIndent = "    ";
    private int depth;

    public TextPlanSink() {
        this.eolIndexes.add(0);
    }

    @Override
    public PlanSink attr(CharSequence name) {
        this.newLine();
        this.sink.put(this.attrIndent);
        this.sink.put(name).put(':').put(' ');
        return this;
    }

    @Override
    public PlanSink child(CharSequence outer, Plannable inner) {
        ++this.depth;
        this.newLine();
        this.sink.put(outer);
        this.child(inner);
        --this.depth;
        return this;
    }

    @Override
    public PlanSink child(Plannable p) {
        ++this.depth;
        this.newLine();
        if (p instanceof RecordCursorFactory) {
            this.factoryStack.push((RecordCursorFactory)p);
            p.toPlan(this);
            this.factoryStack.pop();
        } else {
            p.toPlan(this);
        }
        --this.depth;
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.attrIndent = "  ";
        this.childIndent = "    ";
        this.eolIndexes.clear();
        this.eolIndexes.add(0);
    }

    @Override
    public void end() {
        this.newLine();
    }

    @Override
    public CharSequence getLine(int idx) {
        return this.sink.subSequence(this.eolIndexes.getQuick(idx - 1), this.eolIndexes.getQuick(idx));
    }

    @Override
    public int getLineCount() {
        return this.eolIndexes.size() - 1;
    }

    @Override
    public PlanSink meta(CharSequence name) {
        this.sink.put(" ");
        this.sink.put(name).put(": ");
        return this;
    }

    @Override
    public void of(RecordCursorFactory factory, SqlExecutionContext executionContext) {
        this.clear();
        this.executionContext = executionContext;
        if (executionContext.getBindVariableService() == null) {
            this.childIndent = "&nbsp;&nbsp;&nbsp;&nbsp;";
            this.attrIndent = "&nbsp;&nbsp;";
            this.sink = this.htmlSink;
        } else {
            this.childIndent = "    ";
            this.attrIndent = "  ";
            this.sink = this.textSink;
        }
        if (factory != null) {
            this.factoryStack.push(factory);
            factory.toPlan(this);
        }
        this.end();
    }

    @Override
    public PlanSink type(CharSequence type) {
        this.sink.put(type);
        return this;
    }

    @Override
    public PlanSink val(char c) {
        this.sink.put(c);
        return this;
    }

    @Override
    public PlanSink val(int i) {
        this.sink.put(i);
        return this;
    }

    @Override
    public PlanSink val(long l) {
        this.sink.put(l);
        return this;
    }

    @Override
    public PlanSink val(float f) {
        this.sink.put(f);
        return this;
    }

    @Override
    public PlanSink val(double d) {
        this.sink.put(d);
        return this;
    }

    @Override
    public PlanSink val(boolean b) {
        this.sink.put(b);
        return this;
    }

    @Override
    public PlanSink val(CharSequence cs) {
        this.sink.put(cs);
        return this;
    }

    @Override
    public PlanSink val(Sinkable s) {
        if (s != null) {
            this.sink.put(s);
        }
        return this;
    }

    @Override
    public PlanSink val(Plannable s) {
        if (s != null) {
            s.toPlan(this);
        } else {
            this.sink.put("null");
        }
        return this;
    }

    @Override
    public PlanSink val(long long0, long long1, long long2, long long3) {
        Numbers.appendLong256(long0, long1, long2, long3, this.sink);
        return this;
    }

    @Override
    public PlanSink val(long hash, int geoHashBits) {
        GeoHashes.append(hash, geoHashBits, this.sink);
        return this;
    }

    @Override
    public PlanSink valUuid(long lo, long hi) {
        Numbers.appendUuid(lo, hi, this.sink);
        return this;
    }

    private void newLine() {
        this.eolIndexes.add(this.sink.length());
        for (int i = 0; i < this.depth; ++i) {
            this.sink.put(this.childIndent);
        }
    }
}

