/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.LongIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class CastLongToSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Lk)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            StringSink sink = Misc.getThreadLocalBuilder();
            sink.put(arg.getLong(null));
            return SymbolConstant.newInstance(sink);
        }
        return new Func(arg);
    }

    private static class Func
    extends SymbolFunction
    implements UnaryFunction {
        private final Function arg;
        private final StringSink sink = new StringSink();
        private final LongIntHashMap symbolTableShortcut = new LongIntHashMap();
        private final ObjList<String> symbols = new ObjList();
        private int next = 1;

        public Func(Function arg) {
            this.arg = arg;
            this.symbols.add(null);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public int getInt(Record rec) {
            long value = this.arg.getLong(rec);
            if (value == Long.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            int keyIndex = this.symbolTableShortcut.keyIndex(value);
            if (keyIndex < 0) {
                return this.symbolTableShortcut.valueAt(keyIndex) - 1;
            }
            this.symbolTableShortcut.putAt(keyIndex, value, this.next);
            this.sink.clear();
            this.sink.put(value);
            this.symbols.add(Chars.toString(this.sink));
            return this.next++ - 1;
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            long value = this.arg.getLong(rec);
            if (value == Long.MIN_VALUE) {
                return null;
            }
            int keyIndex = this.symbolTableShortcut.keyIndex(value);
            if (keyIndex < 0) {
                return this.symbols.getQuick(this.symbolTableShortcut.valueAt(keyIndex));
            }
            this.symbolTableShortcut.putAt(keyIndex, value, this.next++);
            this.sink.clear();
            this.sink.put(value);
            String str = Chars.toString(this.sink);
            this.symbols.add(Chars.toString(this.sink));
            return str;
        }

        @Override
        public CharSequence getSymbolB(Record rec) {
            return this.getSymbol(rec);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.arg.init(symbolTableSource, executionContext);
            this.symbolTableShortcut.clear();
            this.symbols.clear();
            this.symbols.add(null);
            this.next = 1;
        }

        @Override
        public boolean isSymbolTableStatic() {
            return false;
        }

        @Override
        @Nullable
        public SymbolTable newSymbolTable() {
            Func copy = new Func(this.arg);
            copy.symbolTableShortcut.putAll(this.symbolTableShortcut);
            copy.symbols.clear();
            copy.symbols.addAll(this.symbols);
            copy.next = this.next;
            return copy;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val("::symbol");
        }

        @Override
        public CharSequence valueBOf(int key) {
            return this.valueOf(key);
        }

        @Override
        public CharSequence valueOf(int symbolKey) {
            return this.symbols.getQuick(TableUtils.toIndexKey(symbolKey));
        }
    }
}

