/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Long256;
import io.questdb.std.Long256HashSet;
import io.questdb.std.Long256Impl;
import io.questdb.std.ObjList;

public class CountDistinctLong256GroupByFunction
extends LongFunction
implements UnaryFunction,
GroupByFunction {
    private final Function arg;
    private final ObjList<Long256HashSet> sets = new ObjList();
    private int setIndex;
    private int valueIndex;

    public CountDistinctLong256GroupByFunction(Function arg) {
        this.arg = arg;
    }

    @Override
    public void clear() {
        this.sets.clear();
        this.setIndex = 0;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        Long256HashSet set;
        if (this.sets.size() <= this.setIndex) {
            set = new Long256HashSet();
            this.sets.extendAndSet(this.setIndex, set);
        } else {
            set = this.sets.getQuick(this.setIndex);
        }
        set.clear();
        Long256 val = this.arg.getLong256A(record);
        if (CountDistinctLong256GroupByFunction.isNotNull(val)) {
            set.add(val.getLong0(), val.getLong1(), val.getLong2(), val.getLong3());
            mapValue.putLong(this.valueIndex, 1L);
        } else {
            mapValue.putLong(this.valueIndex, 0L);
        }
        mapValue.putInt(this.valueIndex + 1, this.setIndex++);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        Long256HashSet set = this.sets.getQuick(mapValue.getInt(this.valueIndex + 1));
        Long256 val = this.arg.getLong256A(record);
        if (CountDistinctLong256GroupByFunction.isNotNull(val)) {
            int index = set.keyIndex(val.getLong0(), val.getLong1(), val.getLong2(), val.getLong3());
            if (index < 0) {
                return;
            }
            set.addAt(index, val.getLong0(), val.getLong1(), val.getLong2(), val.getLong3());
            mapValue.addLong(this.valueIndex, 1L);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public long getLong(Record rec) {
        return rec.getLong(this.valueIndex);
    }

    @Override
    public String getName() {
        return "count_distinct";
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isReadThreadSafe() {
        return false;
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
        columnTypes.add(5);
    }

    @Override
    public void setEmpty(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, 0L);
    }

    @Override
    public void setLong(MapValue mapValue, long value) {
        mapValue.putLong(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
        this.setIndex = 0;
    }

    private static boolean isNotNull(Long256 value) {
        return value != null && value != Long256Impl.NULL_LONG256 && (value.getLong0() != Long.MIN_VALUE || value.getLong1() != Long.MIN_VALUE || value.getLong2() != Long.MIN_VALUE || value.getLong3() != Long.MIN_VALUE);
    }
}

