/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionByte;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionInt;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionLong;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionShort;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class LastGeoHashGroupByFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "last(G)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function function = args.getQuick(0);
        int type = function.getType();
        switch (ColumnType.tagOf(type)) {
            case 14: {
                return new FirstGeoHashGroupByFunctionByte(type, function){

                    @Override
                    public void computeNext(MapValue mapValue, Record record) {
                        mapValue.putByte(this.valueIndex, this.function.getGeoByte(record));
                    }

                    @Override
                    public String getName() {
                        return "last";
                    }
                };
            }
            case 15: {
                return new FirstGeoHashGroupByFunctionShort(type, function){

                    @Override
                    public void computeNext(MapValue mapValue, Record record) {
                        mapValue.putShort(this.valueIndex, this.function.getGeoShort(record));
                    }

                    @Override
                    public String getName() {
                        return "last";
                    }
                };
            }
            case 16: {
                return new FirstGeoHashGroupByFunctionInt(type, function){

                    @Override
                    public void computeNext(MapValue mapValue, Record record) {
                        mapValue.putInt(this.valueIndex, this.function.getGeoInt(record));
                    }

                    @Override
                    public String getName() {
                        return "last";
                    }
                };
            }
        }
        return new FirstGeoHashGroupByFunctionLong(type, function){

            @Override
            public void computeNext(MapValue mapValue, Record record) {
                mapValue.putLong(this.valueIndex, this.function.getGeoLong(record));
            }

            @Override
            public String getName() {
                return "last";
            }
        };
    }
}

