/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.wal.MetadataService;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.std.Misc;
import io.questdb.tasks.TableWriterTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class UpdateOperation
extends AbstractOperation {
    public static final String CMD_NAME = "UPDATE";
    public static final int SENDER_CLOSED_INCREMENT = 7;
    public static final int WRITER_CLOSED_INCREMENT = 10;
    public static final int FULLY_CLOSED_STATE = 17;
    private final AtomicInteger closeState = new AtomicInteger();
    private SqlExecutionCircuitBreaker circuitBreaker = SqlExecutionCircuitBreaker.NOOP_CIRCUIT_BREAKER;
    private boolean executingAsync;
    private RecordCursorFactory factory;
    private volatile boolean requesterTimeout;

    public UpdateOperation(TableToken tableToken, int tableId, long tableVersion, int tableNamePosition) {
        this(tableToken, tableId, tableVersion, tableNamePosition, null);
    }

    public UpdateOperation(TableToken tableToken, int tableId, long tableVersion, int tableNamePosition, RecordCursorFactory factory) {
        this.init(3, CMD_NAME, tableToken, tableId, tableVersion, tableNamePosition);
        this.factory = factory;
    }

    @Override
    public long apply(MetadataService svc, boolean contextAllowsAnyStructureChanges) {
        return svc.getUpdateOperator().executeUpdate(this.sqlExecutionContext, this);
    }

    @Override
    public void close() {
        this.requesterTimeout = true;
        if (!this.executingAsync || this.closeState.addAndGet(7) == 17) {
            this.factory = Misc.free(this.factory);
        }
    }

    public void closeWriter() {
        if (this.executingAsync && this.closeState.addAndGet(10) == 17) {
            this.factory = Misc.free(this.factory);
        }
    }

    @Override
    public AsyncWriterCommand deserialize(TableWriterTask task) {
        return task.getAsyncWriterCommand();
    }

    public void forceTestTimeout() {
        if (this.requesterTimeout || this.circuitBreaker.checkIfTripped()) {
            throw CairoException.nonCritical().put("timeout, query aborted [fd=").put(this.circuitBreaker.getFd()).put(']').setInterruption(true);
        }
    }

    public RecordCursorFactory getFactory() {
        return this.factory;
    }

    @Override
    public boolean isStructural() {
        return false;
    }

    public boolean isWriterClosePending() {
        return this.executingAsync && this.closeState.get() != 10;
    }

    @Override
    public void serialize(TableWriterTask task) {
        super.serialize(task);
        task.setAsyncWriterCommand(this);
    }

    public void start() {
        this.executingAsync = false;
        this.closeState.set(0);
        this.requesterTimeout = false;
    }

    @Override
    public void startAsync() {
        assert (this.closeState.get() == 0);
        this.executingAsync = true;
    }

    public void testTimeout() {
        if (this.requesterTimeout) {
            throw CairoException.nonCritical().put("timeout, query aborted [fd=").put(this.circuitBreaker.getFd()).put(']').setInterruption(true);
        }
        this.circuitBreaker.statefulThrowExceptionIfTripped();
    }

    @Override
    public void withContext(@NotNull SqlExecutionContext sqlExecutionContext) {
        super.withContext(sqlExecutionContext);
        this.circuitBreaker = sqlExecutionContext.getCircuitBreaker();
    }
}

