/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.cairo.sql.Function;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RuntimeIntervalModelBuilder;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;

public class IntrinsicModel
implements Mutable {
    public static final ObjectFactory<IntrinsicModel> FACTORY = IntrinsicModel::new;
    public static final int FALSE = 2;
    public static final int TRUE = 1;
    public static final int UNDEFINED = 0;
    private static final LongList INFINITE_INTERVAL = new LongList();
    public final ObjList<Function> keyExcludedValueFuncs = new ObjList();
    public final ObjList<Function> keyValueFuncs = new ObjList();
    private final RuntimeIntervalModelBuilder runtimeIntervalBuilder = new RuntimeIntervalModelBuilder();
    public ExpressionNode filter;
    public int intrinsicValue = 0;
    public CharSequence keyColumn;
    public QueryModel keySubQuery;

    public RuntimeIntrinsicIntervalModel buildIntervalModel() {
        return this.runtimeIntervalBuilder.build();
    }

    @Override
    public void clear() {
        this.keyColumn = null;
        this.keyValueFuncs.clear();
        this.keyExcludedValueFuncs.clear();
        this.runtimeIntervalBuilder.clear();
        this.filter = null;
        this.intrinsicValue = 0;
        this.keySubQuery = null;
    }

    public void clearBetweenTempParsing() {
        this.runtimeIntervalBuilder.clearBetweenParsing();
    }

    public boolean hasIntervalFilters() {
        return this.runtimeIntervalBuilder.hasIntervalFilters();
    }

    public void intersectEmpty() {
        this.runtimeIntervalBuilder.intersectEmpty();
        this.intrinsicValue = 2;
    }

    public void intersectEquals(Function function) {
        this.runtimeIntervalBuilder.intersectEquals(function);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void intersectIntervals(long lo, long hi) {
        this.runtimeIntervalBuilder.intersect(lo, hi);
    }

    public void intersectIntervals(CharSequence seq, int lo, int lim, int position) throws SqlException {
        this.runtimeIntervalBuilder.intersectIntervals(seq, lo, lim, position);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void intersectIntervals(long lo, Function function, short funcAdjust) {
        this.runtimeIntervalBuilder.intersect(lo, function, funcAdjust);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void intersectIntervals(Function function, long hi, short funcAdjust) {
        this.runtimeIntervalBuilder.intersect(function, hi, funcAdjust);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void intersectRuntimeIntervals(Function intervalStrFunction) {
        this.runtimeIntervalBuilder.intersectDynamicInterval(intervalStrFunction);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void intersectTimestamp(CharSequence seq, int lo, int lim, int position) throws SqlException {
        this.runtimeIntervalBuilder.intersectTimestamp(seq, lo, lim, position);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void setBetweenBoundary(long timestamp) {
        this.runtimeIntervalBuilder.setBetweenBoundary(timestamp);
    }

    public void setBetweenBoundary(Function timestamp) {
        this.runtimeIntervalBuilder.setBetweenBoundary(timestamp);
    }

    public void setBetweenNegated(boolean isNegated) {
        this.runtimeIntervalBuilder.setBetweenNegated(isNegated);
    }

    public void subtractEquals(Function function) {
        this.runtimeIntervalBuilder.subtractEquals(function);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void subtractIntervals(long lo, long hi) {
        this.runtimeIntervalBuilder.subtractInterval(lo, hi);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void subtractIntervals(CharSequence seq, int lo, int lim, int position) throws SqlException {
        this.runtimeIntervalBuilder.subtractIntervals(seq, lo, lim, position);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void subtractRuntimeIntervals(Function intervalStrFunction) {
        this.runtimeIntervalBuilder.subtractRuntimeInterval(intervalStrFunction);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public String toString() {
        return "IntrinsicModel{keyValueFuncs=" + this.keyValueFuncs + ", keyColumn='" + this.keyColumn + '\'' + ", filter=" + this.filter + '}';
    }

    public void unionIntervals(long lo, long hi) {
        this.runtimeIntervalBuilder.union(lo, hi);
    }

    static {
        INFINITE_INTERVAL.add(Long.MIN_VALUE, Long.MAX_VALUE);
    }
}

